/*
 * Created on Feb 17, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI Model object representing of an asset field definition.
 * 
 * @author Vijay Silva
 */
public abstract class UIFieldDefinition implements IsSerializable {

	/* Properties */
	private UIAssetDefinition assetDefinition;
	private String displayName;
	private String ttvFieldName;
	private String ttvFieldXPath;
	private int minimumCount = 1;
	private int maximumCount = 1;
	private UIFieldDefinition parent;
	

	/**
	 * Default constructor
	 */
	public UIFieldDefinition() {
	}

	/**
	 * Constructor - Creates a field with the specified parent and root asset
	 * 
	 * @param assetDefinition The parent asset definition that contains this field definition
	 */
	public UIFieldDefinition(UIAssetDefinition assetDefinition) {
		this.assetDefinition = assetDefinition;
	}

	/**
	 * @return the parent asset
	 */
	public UIAssetDefinition getAssetDefinition() {
		return assetDefinition;
	}

	/**
	 * @param parent the parent asset definition to set
	 */
	public void setAssetDefinition(UIAssetDefinition parent) {
		this.assetDefinition = parent;
	}

	/**
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the display name to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * @return the TTV field name
	 */
	public String getName() {
		return ttvFieldName;
	}

	/**
	 * @param ttvFieldName the TTV field name to set
	 */
	public void setName(String ttvFieldName) {
		this.ttvFieldName = ttvFieldName;
	}

	/**
	 * Get the field XPath
	 * 
	 * @return The field XPath
	 */
	public String getXPath() {
		return this.ttvFieldXPath;
	}

	/**
	 * Set the field XPath
	 * 
	 * @param ttvFieldXPath The field XPath
	 */
	public void setXPath(String ttvFieldXPath) {
		this.ttvFieldXPath = ttvFieldXPath;
	}

	/**
	 * @return the minimum count
	 */
	public int getMinimumCount() {
		return minimumCount;
	}

	/**
	 * @param minimumCount the minimum count to set
	 */
	public void setMinimumCount(int minimumCount) {
		if (minimumCount < 0)
			minimumCount = 0;

		this.minimumCount = minimumCount;
	}

	/**
	 * @return the maximum count
	 */
	public int getMaximumCount() {
		return maximumCount;
	}

	/**
	 * @param maximumCount the maximum count to set
	 */
	public void setMaximumCount(int maximumCount) {
		/* If max count is unlimited, set to MAX_VALUE. Ensure that max count is not 0 */
		if (maximumCount < 0)
			maximumCount = Integer.MAX_VALUE;
		else if (maximumCount == 0)
			maximumCount = 1;

		this.maximumCount = maximumCount;
	}

	
	/**
	 * Determine if the field shows in batch mode, or has any child fields that are displayed in
	 * batch mode
	 * 
	 * @return true if the field or its children is displayed batch mode, false otherwise
	 */
	public abstract boolean isBatch();

	/**
	 * @return the parent field definition
	 */
	public UIFieldDefinition getParent() {
		return parent;
	}

	/**
	 * @param parent the parent field definition to set
	 */
	public void setParent(UIFieldDefinition parent) {
		this.parent = parent;
	}

	/**
	 * Accepts the visitor for this field definition
	 * 
	 * @param visitor The visitor
	 */
	public abstract void accept(IUIFieldDefinitionVisitor visitor);
}
