/*
 * Created on Jun 3, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * Field definition for a simple field that contains a float value
 * 
 * @author Vijay Silva
 */
public class UIFloatFieldDefinition extends UISimpleFieldDefinition {

	private UIFieldDataType datatype = new FloatDataType();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.datatype;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDefinitionVisitor visitor) {
		visitor.visit(this);
	}
}
