/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import java.util.ArrayList;
import java.util.List;

/**
 * UI Model class that represents the definition of a 'Group' asset and its allowed children in a
 * specification.
 * 
 * @author Vijay Silva
 */
public class UIGroupAssetDefinition extends UIAssetDefinition {

	/* Properties */
	private String assetType;
	private List<UIAssetDefinition> children = new ArrayList<UIAssetDefinition>();

	/**
	 * Constructor
	 */
	public UIGroupAssetDefinition() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAssetType() {
		return assetType;
	}

	/**
	 * @param assetType the assetType to set
	 */
	public void setAssetType(String assetType) {
		this.assetType = assetType;
	}

	/**
	 * @return the children
	 */
	public List<UIAssetDefinition> getChildren() {
		return children;
	}

	/**
	 * @param children the children to set
	 */
	public void setChildren(List<UIAssetDefinition> children) {
		if (children != null) {
			for (UIAssetDefinition definition : children) {
				definition.setParentDefinition(this);
				definition.setSpecification(this.getSpecification());
			}
		}
		this.children = (children != null) ? children : new ArrayList<UIAssetDefinition>();
	}

	/**
	 * Get an immediate child definition with matching asset type
	 * 
	 * @param assetType The asset type
	 * @return the asset definition
	 */
	public UIAssetDefinition getChildDefinition(String assetType) {
		UIAssetDefinition definition = null;

		for (UIAssetDefinition child : children) {
			if (assetType.equals(child.getAssetType())) {
				definition = child;
				break;
			}
		}

		return definition;
	}

	/**
	 * Add a new child asset definition for this group asset definition
	 * 
	 * @param childDefinition the child asset definition
	 */
	public void addChild(UIAssetDefinition childDefinition) {
		if (childDefinition != null) {
			childDefinition.setParentDefinition(this);
			childDefinition.setSpecification(this.getSpecification());
			this.children.add(childDefinition);
		}
	}

	/**
	 * Set the specification in this asset definition and all the children
	 * 
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition#setSpecification(com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification)
	 */
	@Override
	public void setSpecification(UIAssetSpecification specification) {
		super.setSpecification(specification);
		for (UIAssetDefinition child : children)
			child.setSpecification(specification);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIAssetDefinitionVisitor visitor) {
		visitor.visit(this);
	}
}
