/*
 * Created on May 28, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification.option;

import java.util.Comparator;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * A Value option represents a typed value that is allowed by a field.
 * 
 * @author Vijay Silva
 */
public class UIValueOption implements IsSerializable 
{
	public final static StringComparator STRING_COMPARATOR = new StringComparator();

	
	private String name;
	private String value;

	/**
	 * Creates a value option
	 */
	public UIValueOption() {
	}

	/**
	 * Creates a Value Option with the given display name and value
	 * 
	 * @param name The display name
	 * @param value The value
	 */
	public UIValueOption(String name, String value) {
		this.name = name;
		this.value = value;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	
	/////////////////////////////////////////////////////////////////////////////
	
	private static class StringComparator implements Comparator<UIValueOption>
	{
		@Override
		public int compare(UIValueOption o1, UIValueOption o2)
		{
			if(o2 == null || o2.getName() == null) return 1;
			if(o1 == null || o1.getName() == null) return -1;
			
			return o1.getName().compareTo(o2.getName());
		}
	}
	
}
