package com.tandbergtv.cms.portal.ui.title.client.model.uiservice;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * UI service api that helps execute an operation on a given list of ids and
 * input and re direct to the destination page.
 * 
 * @author spuranik
 * 
 */
public interface ITitleActionService extends Service, IsSerializable {

	/**
	 * Given the list of ids, each implementation will perform the
	 * operation it is aware of and return back to the callback sent in the
	 * call.
	 * 
	 * @param titleIds
	 */
	void execute(List<Long> ids, String serviceParameter, IActionInput input, 
			AsyncCallback<IOperationResult> callback);

	/**
	 * The implementation is responsible to set the result page as the active ui
	 * screen. Note that the service is also responsible for setting the url not
	 * just replacing the ui widgets. Results (any info strings) obtained from
	 * the execution are passed in so that it is available to the result page.
	 * 
	 * @param result
	 */
	void gotoResultPage(IOperationResult result, IView sourceView);
	
	/**
	 * Gets list of names available for the user to choose from when this service is selected.
	 * 
	 */
	void getServiceParameters(NeptuneAsyncCallback<List<String>> callback);
	
	/**
	 * Gets list of action parameters.
	 * 
	 */
	Map<String, String> getServiceActionParameters();

	/**
	 * Gets the name of this service.
	 * 
	 * @return
	 */
	String getName();

	/**
	 * Gets the description of this service
	 * 
	 * @return
	 */
	String getDescription();

	/**
	 * Indicates that a confirmation is required before proceeding to execute
	 * the operation.
	 * 
	 * @return
	 */
	boolean getConfirmation();
	
	/**
	 * The service can respond back if it should be set as the selected item based on the input.
	 * 
	 * @param inputData
	 * @return
	 */
	boolean isSelected(ViewInput inputData);

	boolean needTitlesTobeSelected();
}
