package com.tandbergtv.cms.portal.ui.title.client.model.uiservice;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;


/**
 * ui service which helps with title's progress stuff.
 * 
 * All components which provide a status message for title should implement this
 * interface.
 * 
 * @author spuranik
 * 
 */
public interface ITitleProgressService extends Service, IsSerializable {

	public class Hyperlink {
		private String text, targetHistoryToken;
		private boolean asHTML;

		public Hyperlink(String text) {
			this(text, null);
		}
		
		public Hyperlink(String text, String targetHistoryToken) {
			this(text, false, targetHistoryToken);
		}

		public Hyperlink(String text, boolean asHTML, String targetHistoryToken) {
			this.text = text;
			this.asHTML = asHTML;
			this.targetHistoryToken = targetHistoryToken;
		}
		
		public String getText() {
			return text;
		}

		public boolean isAsHTML() {
			return asHTML;
		}

		public String getTargetHistoryToken() {
			return targetHistoryToken;
		}
	}
	
	/**
	 * Prepares a hyperlink for the given source id if component name and entity
	 * matches.
	 * 
	 * @param componentName
	 * @param entityName
	 * @param sourceId
	 * @param titleRevision
	 * @return {@link Hyperlink} object which has a link to the entity with the given
	 *         source id
	 */
	Hyperlink getLink(String componentName, String entityName,
			String sourceId, String titleRevision);
}