package com.tandbergtv.cms.portal.ui.title.client.model.uiservice;

import java.util.List;

import com.google.gwt.user.client.ui.Widget;

/**
 * Represents the source view which initiated an operation.
 * 
 * @author spuranik
 * 
 */
public interface IView {

	/**
	 * Report an error if the requested operation was not successfully
	 * completed.
	 */
	void reportFailure(Throwable caught);

	/**
	 * Returns the container which contains this widget.
	 * 
	 * @return
	 */
	Widget getParentContainer();

	/**
	 * Generated after the operation has been executed. This is a chance given
	 * to the source view to cleanup any state it might want to erase before
	 * going to the operation result page.
	 */
	void cleanup();

	/**
	 * This will clear any state the view has and repaint the complete page. It will also render 
	 * the message provided.
	 * 
	 * @param infoMessage
	 */
	void refresh(String infoMessage);

	/**
	 * This will display the info message on the page without repainting the entire the page. 
	 * The current state of the page is retained. 
	 *  
	 * @param infoMessage
	 */
	void show(String infoMessage);
	
	/**
	 * Retrieves the ids of the selected items in the view. 
	 * 
	 * @return
	 */
	List<Long> getSeletedRecordIds();

	/**
	 * The view impl is responsible to provide any input that will be sent to
	 * the service for execution.
	 * 
	 * @return
	 */
	IActionInput getInputToExecution();
	
	/**
	 * Shows yourself based on the readonly flag.
	 * 
	 * @param readOnly
	 */
	void show(boolean readOnly);
}
