package com.tandbergtv.cms.portal.ui.title.client.model.uiservice;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Callback that is passed to the ui services that can operate on a list of
 * title ids. It is the ui service's responsibility to invoke this callback
 * after the operation has been done irrespective of whether or not the
 * operation was successful. Any results obtained from the execution can be
 * returned back via an implementation of ITitleOperationResult.
 * 
 * @author spuranik
 * 
 */
public class OperationCompletedAsyncCallback extends
		NeptuneAsyncCallback<IOperationResult> {

	// instance of the service which is processing this operation.
	private ITitleActionService service;
	
	// view that initiated the operation request
	private IView sourceView; 

	public OperationCompletedAsyncCallback(ITitleActionService serviceImpl, IView parentView) {
		this.service = serviceImpl;
		this.sourceView = parentView;
	}

	public void onNeptuneFailure(Throwable caught) {
		// if there was a failure performing the action on the titles, show the
		// error message on the title list page.
		sourceView.reportFailure(caught);
	}

	public void onNeptuneSuccess(IOperationResult result) {
		// upon successful execution of the operation, send back the result to
		// the ui service and ask it to go to the result page.

		// NOTE: at this point the service takes complete control over to set
		// the ui flow.
		
		// clear the view state before going to the result page
		sourceView.cleanup();
		service.gotoResultPage(result, sourceView);
	}

	/**
	 * @return the service
	 */
	public ITitleActionService getService() {
		return service;
	}

	/**
	 * @param service
	 *            the service to set
	 */
	public void setService(ITitleActionService service) {
		this.service = service;
	}

	/**
	 * @return the parent
	 */
	public IView getParentView() {
		return sourceView;
	}

	/**
	 * @param parent the parent to set
	 */
	public void setParentView(IView parent) {
		this.sourceView = parent;
	}
}
