/**
 * File Name	:	OverridesLisPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 25, 2011 6:35:14 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.ui.title.client.msooverrides;

import java.util.List;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy.KeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy.KeyboardSelectionPolicy;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEvent;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOsPanel extends Composite {

	interface MyUiBinder extends UiBinder<Widget, MSOsPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

	final ListDataProvider<UIMSO> dataProvider;

	@UiField
	ScrollPanel scrollPanel;

	@UiField(provided=true)
	CellList<UIMSO> msosList;
			
	private Long siteId;
	
	private HandlerManager eventBus;

	private MSOOverridesConstants constants = GWT.create(MSOOverridesConstants.class);
	
	/**
	 * 
	 */
	public MSOsPanel() {
	    ProvidesKey<UIMSO> keyProvider = new ProvidesKey<UIMSO>() {
	        public Object getKey(UIMSO item) {
	          // Always do a null check.
	          return (item == null) ? null : item.getMsoId();
	        }
	      };
	      
		msosList = new CellList<UIMSO>(new UIMSOCell(), keyProvider);
		initWidget(uiBinder.createAndBindUi(this));

		// Create a list data provider.
	    dataProvider = new ListDataProvider<UIMSO>();

	    // Add the cellList to the dataProvider.
	    dataProvider.addDataDisplay(msosList);
		
	    SafeHtmlBuilder sb = new SafeHtmlBuilder();
	    sb.appendEscaped(constants.noMSOs());
	    msosList.setEmptyListMessage(sb.toSafeHtml());
	    msosList.setPageSize(10000);
	    msosList.setKeyboardPagingPolicy(KeyboardPagingPolicy.INCREASE_RANGE);
	    msosList.setKeyboardSelectionPolicy(KeyboardSelectionPolicy.BOUND_TO_SELECTION);
	    
		// Add a selection model to handle user selection.
		final SingleSelectionModel<UIMSO> selectionModel = new SingleSelectionModel<UIMSO>(keyProvider);
		msosList.setSelectionModel(selectionModel);
		selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler() {
					public void onSelectionChange(SelectionChangeEvent event) {
						UIMSO selected = selectionModel.getSelectedObject();
						if ((selected != null) && (eventBus != null)) {
							eventBus.fireEvent(new MSOSelectedEvent(selected));
						}
					}
				});
		
	}
	
	public SelectionModel<? super UIMSO> getSelectionModel() {
		return msosList.getSelectionModel();
	}
	
	public void setSelected(UIMSO uiMSO, boolean selected) {
		getSelectionModel().setSelected(uiMSO, selected);
	}
	
	public void setMSOs(List<UIMSO> uiMSOs) {
		dataProvider.setList(uiMSOs);
		if (uiMSOs.size() > 0) {
			msosList.getSelectionModel().setSelected(uiMSOs.get(0), true);
		}
	}
	
	public boolean isEmpty() {
		boolean isEmpty = false;
		
		isEmpty = msosList.getRowCount() == 0;
		
		return isEmpty;
	}

	public Long getSiteId() {
		return siteId;
	}

	public void setSiteId(Long siteId) {
		this.siteId = siteId;
	}

	public HandlerManager getEventBus() {
		return eventBus;
	}

	public void setEventBus(HandlerManager eventBus) {
		this.eventBus = eventBus;
	}


	/**
	 * A custom {@link Cell} used to render a {@link UIMSO}.
	 */
	private static class UIMSOCell extends AbstractCell<UIMSO> {
		@Override
		public void render(Context context, UIMSO uiMSO, SafeHtmlBuilder sb) {
			if (uiMSO != null) {
				sb.appendEscaped(uiMSO.getMsoName());
			}
		}
	}
	
	public void updateSize(int offsetWidth, int offsetHeight) {
		int height = Window.getClientHeight() - offsetHeight - 40;
		scrollPanel.setHeight(height + "px");
	}

}
