/*
 * Created on Feb 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.service.specification;

import java.util.Collection;
import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Service that provides access the UIAssetSpecification model object used for determining the
 * assets and metadata fields allowed / supported by a specification.
 * 
 * @author Vijay Silva
 */
@RemoteServiceRelativePath("service/title/specification/IUISpecificationManager")
public interface IUISpecificationManager extends RemoteService {

	/**
	 * Gets all available specifications ordered by display name
	 * 
	 * @return The list of specifications ordered by display name
	 */
	public List<UIAssetSpecificationListItem> getAll() throws NeptuneException;

	/**
	 * Gets specs for preview screen. (These specs should have fromTTV translator)
	 * @return
	 * @throws NeptuneException
	 */
	public List<UIAssetSpecificationListItem> getPreviewSpecs() throws NeptuneException;
	
	/**
	 * Get the default specification list item for the current user
	 * 
	 * @return The default specification list item
	 */
	public UIAssetSpecificationListItem getDefaultListItem() throws NeptuneException;

	/**
	 * Gets the default specification for the specified user
	 * 
	 * @param userName
	 * @return
	 */
	public UIAssetSpecification getUISpecification() throws NeptuneException;

	Collection<UIAssetDefinition> getAllUISpecifications();
	
	/**
	 * get UISpecfication object for a a given specification type
	 * @param type -Specification type = SERIES OR PACKAGE
	 * @return
	 */
	public UIAssetSpecification getUIAssetSpecification(String type);
}
