/*
 * Created on Feb 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */
package com.tandbergtv.cms.portal.ui.title.client.service.specification;

import java.util.Collection;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;

/**
 * Service that provides access the UIAssetSpecification model object used for determining the
 * assets and metadata fields allowed / supported by a specification.
 * 
 * @author Vijay Silva
 * @generated generated asynchronous callback interface to be used on the client side
 */

public interface IUISpecificationManagerAsync {

	/**
	 * Gets all available specifications ordered by display name
	 * 
	 * @gwt.callbackReturn The list of specifications ordered by display name
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getAll(AsyncCallback<List<UIAssetSpecificationListItem>> callback);

	/**
	 * Gets list of specs for which output translator is available, so UI can preview it.
	 * @param callback
	 */
	void getPreviewSpecs(AsyncCallback<List<UIAssetSpecificationListItem>> callback);
	
	/**
	 * Get the default specification list item for the current user
	 * 
	 * @gwt.callbackReturn The default specification list item
	 * @param  callback the callback that will be called to receive the return value (see <code>@gwt.callbackReturn</code> tag)
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getDefaultListItem(AsyncCallback<UIAssetSpecificationListItem> callback);

	/**
	 * Gets the default specification for the specified user
	 * 
	 * @param userName
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getUISpecification(AsyncCallback<UIAssetSpecification> callback);
	
	void getAllUISpecifications(AsyncCallback<Collection<UIAssetDefinition>> callback);
	
	void getUIAssetSpecification(String type, AsyncCallback<UIAssetSpecification> callback);
		
}
