/*
 * Created on May 1, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.bundle;

import com.google.gwt.resources.client.ClientBundleWithLookup;
import com.google.gwt.resources.client.ImageResource;

/**
 * Client Bundle for images
 * 
 * @author Vijay Silva
 */
public interface ITitleClientBundle extends ClientBundleWithLookup {

    // ========================================================================
    // ===================== TITLE ICONS
    // ========================================================================

    @Source("masterTitle.png")
    ImageResource originalTitle();

    @Source("siteTitle.png")
    ImageResource siteTitle();

    @Source("masterTitle-changed-after-targeting.png")
    ImageResource originalTitleDifferent();

    @Source("masterTitle-unchanged-after-targeting.png")
    ImageResource originalTitleNotDifferent();

    @Source("siteTitle-changed-after-distribution.png")
    ImageResource distributedTitleDifferent();

    @Source("siteTitle-unchanged-after-distribution.png")
    ImageResource distributedTitleNotDifferent();

    @Source("success.gif")
    ImageResource progressItemSucess();

    @Source("failure.gif")
    ImageResource progressItemFailure();

    // ========================================================================
    // ===================== TITLE STATUS ICONS
    // ========================================================================

    @Source("title-draft.png")
    ImageResource statusDRAFT();

    @Source("title-committed.png")
    ImageResource statusCOMMITTED();

    @Source("title-ready.png")
    ImageResource statusREADY();

    @Source("title-approved.png")
    ImageResource statusAPPROVED();

    @Source("title-retired.png")
    ImageResource statusRETIRED();

    // ========================================================================
    // ===================== TITLE DISTRIBUTION STATUS ICONS
    // ========================================================================

    @Source("distributionSite.gif")
    ImageResource distributionSite();

    @Source("distributionSiteError.gif")
    ImageResource distributionSiteError();
    
    @Source("site-distribution-none.png")
    ImageResource distributionStatusNONE();
    
    @Source("site-distribution-waiting.png")
    ImageResource distributionStatusWAITING();

    @Source("site-distribution-targeted.png")
    ImageResource distributionStatusTARGETED();

    @Source("site-distribution-ready.png")
    ImageResource distributionStatusREADY_FOR_DISTRIBUTION();

    @Source("site-distribution-in-progress.png")
    ImageResource distributionStatusIN_PROGRESS();

    @Source("site-distribution-distributed.png")
    ImageResource distributionStatusDISTRIBUTED();

    @Source("site-distribution-failed.png")
    ImageResource distributionStatusFAILED();
    
    @Source("site-distribution-waiting-dependency.png")
    ImageResource distributionStatusWAITING_FOR_DEPENDENCY();


    // ========================================================================
    // ===================== TITLE TRACKING STATUS ICONS
    // ========================================================================

    @Source("site-tracking-targeted.png")
    ImageResource trackingStatusTARGETED();

    @Source("site-tracking-deployment-in-progress.png")
    ImageResource trackingStatusDEPLOYMENT_IN_PROGRESS();

    @Source("site-tracking-deployment-failed.png")
    ImageResource trackingStatusDEPLOYMENT_FAILED();

    @Source("site-tracking-deployed.png")
    ImageResource trackingStatusDEPLOYED();

    @Source("site-tracking-not-deployed.png")
    ImageResource trackingStatusNOT_DEPLOYED();
    
    // ========================================================================
    // ===================== TITLE SEARCH ICONS
    // ========================================================================
    
    @Source("save16.gif")
    ImageResource save16();
    
 // ========================================================================
    // ===================== OFFER ICONS
    // ========================================================================

    @Source("offer-type-master.png")
    ImageResource originalOffer();

    @Source("offer-type-site.png")
    ImageResource siteOffer();

    @Source("master-offer-changed-after-targeting.png")
    ImageResource originalOfferDifferent();

    @Source("master-offer-unchanged-after-targeting.png")
    ImageResource originalOfferNotDifferent();

    @Source("site-offer-changed-after-distribution.png")
    ImageResource distributedOfferDifferent();

    @Source("site-offer-unchanged-after-distribution.png")
    ImageResource distributedOfferNotDifferent();


    // ========================================================================
    // ===================== OFFER STATUS ICONS
    // ========================================================================

    @Source("offer-draft.png")
    ImageResource offerStatusDRAFT();

    @Source("offer-committed.png")
    ImageResource offerStatusCOMMITTED();

    @Source("offer-ready.png")
    ImageResource offerStatusREADY();

    @Source("offer-approved.png")
    ImageResource offerStatusAPPROVED();

    @Source("offer-retired.png")
    ImageResource offerStatusRETIRED();
    
    @Source("offer-icon.png")
    ImageResource offerIcon();

}
