/*
 * Created on May 1, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.bundle;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;

/**
 * Helps build the icons related to a title
 * 
 * @author Vijay Silva
 */
public class TitleClientBundle {

	/* The bundle and constants */
	private ITitleClientBundle titleBundle = GWT.create(ITitleClientBundle.class);
	private TitleImageConstants constants = GWT.create(TitleImageConstants.class);
	
	private static final String STATUS_PREFIX = "status";
	private static final String DISTRIBUTION_STATUS_PREFIX = "distributionStatus";
	private static final String TRACKING_STATUS_PREFIX = "trackingStatus";
	
	private static final String OFFER_STATUS_PREFIX = "offerStatus";

	/**
	 * Update the image with the Title Status Icon and tool tip
	 * 
	 * @param icon The image widget to update with the icon
	 * @param status The status to use for getting appropriate image
	 */
	public void updateTitleStatusIcon(Image icon, UITitleStatus status, Boolean isOffer) {
		updateTitleStatusIcon(icon, status.toString(), isOffer);
	}

	/**
	 * Update the image with the Title Status Icon and tool tip
	 * 
	 * @param icon The icon to update
	 * @param status The status name (as defined in {@link UITitleStatus} enumeration)
	 */
	public void updateTitleStatusIcon(Image icon, String status, Boolean isOffer) {
		if(isOffer) {
			updateIcon(icon, OFFER_STATUS_PREFIX + status);
		}else {
			updateIcon(icon, STATUS_PREFIX + status);
		}
	}

	/**
	 * Get the name for the Title Status
	 * 
	 * @param status The title status
	 * @return The display name
	 */
	public String getStatusName(UITitleStatus status) {
		return getStatusName(status.toString());
	}

	/**
	 * Get the name for the Title Status
	 * 
	 * @param status The title status name (as defined in {@link UITitleStatus} enumeration)
	 * @return The display name
	 */
	public String getStatusName(String status) {		
			return constants.getString(STATUS_PREFIX + status);		
	}

	/**
	 * Update the image with the Title Distribution Status Icon and tool tip
	 * 
	 * @param status The status to use for getting appropriate image
	 * @param icon The image widget to update with the icon
	 */
	public void updateDistributionStatusIcon(Image icon, UIDistributionStatus status) {
		updateDistributionStatusIcon(icon, status.toString());
	}

	/**
	 * Update the image with the Title Status Icon and tool tip
	 * 
	 * @param icon The icon to update
	 * @param status The status name (as defined in {@link UIDistributionStatus} enumeration)
	 */
	public void updateDistributionStatusIcon(Image icon, String status) {
		updateIcon(icon, DISTRIBUTION_STATUS_PREFIX + status);
	}

	/**
	 * Get the name for the Title Distribution Status
	 * 
	 * @param status The title distribution status
	 * @return The display name
	 */
	public String getDistributionStatusName(UIDistributionStatus status) {
		return getDistributionStatusName(status.toString());
	}

	/**
	 * Get the name for the Title Distribution Status
	 * 
	 * @param status The distribution status name (as defined in {@link UIDistributionStatus}
	 *        enumeration)
	 * @return The display name
	 */
	public String getDistributionStatusName(String status) {
		return constants.getString(DISTRIBUTION_STATUS_PREFIX + status);
	}

	/**
	 * Update the image with the Title Tracking Status Icon and tool tip
	 * 
	 * @param status The status to use for getting appropriate image
	 * @param icon The image widget to update with the icon
	 */
	public void updateTrackingStatusIcon(Image icon, UITrackingStatus status) {
		updateTrackingStatusIcon(icon, status.toString());
	}

	/**
	 * Update the image with the Title Tracking Status Icon and tool tip
	 * 
	 * @param icon The icon to update
	 * @param status The status name (as defined in {@link UITrackingStatus} enumeration)
	 */
	public void updateTrackingStatusIcon(Image icon, String status) {
		updateIcon(icon, TRACKING_STATUS_PREFIX + status);
	}

	/**
	 * Get the name for the Title Tracking Status
	 * 
	 * @param status The title tracking status
	 * @return The display name
	 */
	public String getTrackingStatusName(UITrackingStatus status) {
		return getTrackingStatusName(status.toString());
	}

	/**
	 * Get the name for the Title Tracking Status
	 * 
	 * @param status The tracking status name (as defined in {@link UITrackingStatus} enumeration)
	 * @return The display name
	 */
	public String getTrackingStatusName(String status) {
		return constants.getString(TRACKING_STATUS_PREFIX + status);
	}

	/**
	 * Update the image with the appropriate icon defined in the {@link ITitleClientBundle}. Provide
	 * the method name from the bundle to update the image with the appropriate icon.
	 * 
	 * @param icon The image to update
	 * @param methodName The method name from {@link ITitleClientBundle}
	 */
	public void updateIcon(Image icon, String methodName) 
	{
		try
		{
			ImageResource resource = (ImageResource) titleBundle.getResource(methodName);
			String title = constants.getString(methodName);
	
			/* Update the image */
			icon.setResource(resource);
			icon.setTitle(title);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}

	/**
	 * Get the title used as tool tip for the icons defined in {@link ITitleClientBundle}
	 * 
	 * @param methodName The method name from {@link ITitleClientBundle} (which must have an
	 *        equivalent method defined in {@link TitleImageConstants}.
	 * @return The title used as a tool tip
	 */
	public String getIconTitle(String methodName) {
		return constants.getString(methodName);
	}

	/**
	 * @return the titleBundle
	 */
	public ITitleClientBundle getTitleBundle() {
		return titleBundle;
	}

	/**
	 * @return the constants
	 */
	public TitleImageConstants getConstants() {
		return constants;
	}
}
