/*
 * Created on May 26, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

/**
 * Widget Factory that create widgets that can be used for a specific data type
 * 
 * @author Vijay Silva
 */
public abstract class DataTypeWidgetFactory {

	/**
	 * Constructor
	 */
	public DataTypeWidgetFactory() {
	}

	/**
	 * Creates a Boolean DataType Widget
	 * 
	 * @param configuration The widget configuration
	 * @return The data type widget
	 */
	public abstract DataTypeWidget<Boolean> createBooleanWidget(WidgetConfiguration configuration);

	/**
	 * Creates a Integer DataType Widget
	 * 
	 * @param configuration The widget configuration
	 * @return The data type widget
	 */
	public abstract DataTypeWidget<Long> createIntegerWidget(WidgetConfiguration configuration);

	/**
	 * Creates a Float DataType Widget
	 * 
	 * @param configuration The widget configuration
	 * @return The data type widget
	 */
	public abstract DataTypeWidget<String> createFloatWidget(WidgetConfiguration configuration);

	/**
	 * Creates a Date DataType Widget
	 * 
	 * @param configuration The widget configuration
	 * @return The data type widget
	 */
	public abstract DataTypeWidget<String> createDateWidget(DateWidgetConfiguration configuration);

	/**
	 * Creates a Time DataType Widget
	 * 
	 * @param configuration The widget configuration
	 * @return The data type widget
	 */
	public abstract DataTypeWidget<String> createTimeWidget(TimeWidgetConfiguration configuration);

	/**
	 * Creates a String DataType Widget
	 * 
	 * @param configuration The widget configuration
	 * @return The data type widget
	 */
	public abstract DataTypeWidget<String> createStringWidget(StringWidgetConfiguration configuration);
}
