/*
 * Created on May 30, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.google.gwt.i18n.client.Messages;

/**
 * Messages used in the data type widgets
 * 
 * @author Vijay Silva
 */
public interface DataTypeWidgetMessages extends Messages {

	/**
	 * @return The string for 'null' boolean value
	 */
	public String booleanWidgetUndefinedValue();

	/**
	 * @return The string for 'true' boolean value
	 */
	public String booleanWidgetTrueValue();

	/**
	 * @return The string for 'false' boolean value
	 */
	public String booleanWidgetFalseValue();

	/**
	 * @return The tool tip to use for boolean data type widgets
	 */
	public String booleanWidgetToolTip();

	/**
	 * @return The tool tip to use for boolean data type widgets in error state
	 */
	public String booleanWidgetErrorToolTip();

	/**
	 * @return The tool tip to use for string data type widgets
	 */
	public String stringWidgetToolTip();

	/**
	 * @return The tool tip to use for string data type widgets in error state
	 */
	public String stringWidgetErrorToolTip();

	/**
	 * @return The tool tip to use for float data type widgets
	 */
	public String floatWidgetToolTip();

	/**
	 * @return The tool tip to use for float data type widgets in error state
	 */
	public String floatWidgetErrorToolTip();

	/**
	 * @return The tool tip to use for integer data type widgets
	 */
	public String integerWidgetToolTip();

	/**
	 * @return The tool tip to use for integer data type widgets in error state
	 */
	public String integerWidgetErrorToolTip();

	/**
	 * @return The output format for time data type
	 */
	public String timeWidgetFormat();

	/**
	 * @return The default tool tip for time widgets
	 */
	public String timeWidgetToolTip(String format);

	/**
	 * @return The default tool tip for time widgets
	 */
	public String timeCodeWidgetToolTip();

	/**
	 * @return The error tool tip for time widgets
	 */
	public String timeWidgetErrorToolTip(String format);

	/**
	 * @return The error tool tip for time widgets
	 */
	public String timeCodeWidgetErrorToolTip();
	
	/**
	 * @return the date format string for date widgets
	 */
	public String dateWidgetFormat();

	/**
	 * @return The tool tip for date widgets
	 */
	public String dateWidgetToolTip(String format);

	/**
	 * @return The error tool tip for date widgets
	 */
	public String dateWidgetErrorToolTip(String format);
	
	/**
	 * @return Error message for required fields
	 */
	public String requiredFieldErrorToolTip();
}
