/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;


import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;

/**
 * Widget Configuration for date data type widgets
 * 
 * @author Vijay Silva
 */
public class DateWidgetConfiguration extends WidgetConfiguration 
{
	private String dateFormat;

	/**
	 * Constructor
	 */
	public DateWidgetConfiguration() {
		super();
	}

	/**
	 * Constructs widget configuration for the field definition
	 * 
	 * @param fieldDefinition The field definition
	 */
	public DateWidgetConfiguration(UIDateFieldDefinition fieldDefinition) {
		super(fieldDefinition);
		this.setOptions(fieldDefinition.getSuggestedValues());
		this.setDateFormat(fieldDefinition.getDisplayFormat());
	}

	/**
	 * @return the dateFormat
	 */
	public String getDateFormat() {
		return dateFormat;
	}

	/**
	 * @param dateFormat the dateFormat to set
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}
}
