package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Simple key-value pair implementation
 * @author eyevkar
 */
public class KeyValuePair implements IsSerializable, Comparable<KeyValuePair> {
	private String key;
	private String value;

	/**
	 * Default constructor. Required by GWT to serialize the object.
	 */
	public KeyValuePair() {
	}

	/**
	 * Constructor
	 * @param key
	 * @param value
	 */
	public KeyValuePair(String key, String value) {
		this.key = key;
		this.value = value;
	}

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}

	@Override
	public int compareTo(KeyValuePair o) {
		if (value != null) {
			return (o.getValue() != null) ? this.value.compareTo(o.getValue()) : 1;
		}

		return (o.getValue() == null) ? 0 : -1;
	}
}
