/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;

/**
 * Widget Configuration for string data type widgets
 * 
 * @author Vijay Silva
 */
public class StringWidgetConfiguration extends WidgetConfiguration {

	private boolean longForm = false;
	private boolean isPositionField = false;

	/**
	 * Constructor
	 */
	public StringWidgetConfiguration() {
		super();
	}

	/**
	 * Constructs widget configuration for the field definition
	 * 
	 * @param fieldDefinition The field definition
	 */
	public StringWidgetConfiguration(UIStringFieldDefinition fieldDefinition) {
		super(fieldDefinition);
		this.setLongForm(fieldDefinition.isLongForm());
		this.setPositionField(fieldDefinition.isPositionField());
	}

	/**
	 * @return the longForm
	 */
	public boolean isLongForm() {
		return longForm;
	}

	/**
	 * @param longForm the longForm to set
	 */
	public void setLongForm(boolean longForm) {
		this.longForm = longForm;
	}

	public boolean isPositionField() {
		return isPositionField;
	}

	public void setPositionField(boolean isPositionField) {
		this.isPositionField = isPositionField;
	}
}
