/*
 * Created on Jun 4, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;

/**
 * Widget Configuration for time data type widgets
 * 
 * @author Vijay Silva
 */
public class TimeWidgetConfiguration extends WidgetConfiguration {

	private String timeFormat;

	/**
	 * Constructor
	 */
	public TimeWidgetConfiguration() {
		super();
	}

	/**
	 * Constructs widget configuration for the field definition
	 * 
	 * @param fieldDefinition The field definition
	 */
	public TimeWidgetConfiguration(UITimeFieldDefinition fieldDefinition) {
		super(fieldDefinition);
		this.setTimeFormat(fieldDefinition.getDisplayFormat());
	}

	/**
	 * @return the timeFormat
	 */
	public String getTimeFormat() {
		return timeFormat;
	}

	/**
	 * @param timeFormat the timeFormat to set
	 */
	public void setTimeFormat(String timeFormat) {
		this.timeFormat = timeFormat;
	}
}
