/*
 * Created on Jun 3, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

/**
 * Maintains the configuration required when creating a data type widget using the factory.
 * 
 * @author Vijay Silva
 */
public class WidgetConfiguration 
{
	private List<UIValueOption> options;
	
	private boolean anyValueAllowed = true;
	private Set<String> excludedOptionKeys;
	private boolean isReadOnly = false;
	

	public WidgetConfiguration() {
	}
	
	/**
	 * Constructor. Creates a default configuration (no options, any value allowed).
	 */
	public WidgetConfiguration(UISimpleFieldDefinition definition) {
		this.setAnyValueAllowed(definition.isAnyValueAllowed());
		this.options = definition.getSuggestedValues();
	}
		

	/**
	 * Determine if this configuration contains any options
	 * 
	 * @return The
	 */
	public boolean hasOptions() {
		return (options != null && !options.isEmpty());
	}

	/**
	 * @return the anyValueAllowed
	 */
	public boolean isAnyValueAllowed() {
		return anyValueAllowed;
	}

	/**
	 * @param anyValueAllowed the anyValueAllowed to set
	 */
	public void setAnyValueAllowed(boolean anyValueAllowed) {
		this.anyValueAllowed = anyValueAllowed;
	}

	public Set<String> getExcludedOptionKeys() {
		return excludedOptionKeys;
	}

	public void setExcludedOptionKeys(Set<String> excludedOptionKeys) {
		this.excludedOptionKeys = excludedOptionKeys;
	}

	public boolean isReadOnly() {
		return isReadOnly;
	}

	public void setReadOnly(boolean isReadOnly) {
		this.isReadOnly = isReadOnly;
	}
	
	public List<UIValueOption> getOptions() {
		return options;
	}

	public void setOptions(List<UIValueOption> options) {
		this.options = options;
	}
	
	
	public void sortOptions()
	{
		sortOptions(UIValueOption.STRING_COMPARATOR);
	}
	
	
	public void sortOptions(Comparator<UIValueOption> comparator)
	{
		if(options != null)
		{
			Collections.sort(options, comparator);
		}
	}
	
}
