package com.tandbergtv.cms.portal.ui.title.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasKeyDownHandlers;
import com.google.gwt.event.dom.client.HasKeyPressHandlers;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseMoveHandlers;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.dom.client.HasMouseUpHandlers;
import com.google.gwt.event.dom.client.HasMouseWheelHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable.Cell;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase.TextAlignConstant;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * A Text Box Widget that has a special editing feature for the VOD Position Field. If only there was a getWidget() method in TypedTextBoxWidget.
 * TODO refactor so that this can extend TypedTextBoxWigent.
 * 
 * @author Nicholas Brulois
 */
public class TypedPositionFieldWidget<DataType> extends DataTypeWidget<DataType> implements HasName,
        HasDirection, HasText, HasClickHandlers, HasKeyPressHandlers, HasKeyUpHandlers,
        HasKeyDownHandlers, HasMouseDownHandlers, HasMouseMoveHandlers, HasMouseOutHandlers,
        HasMouseOverHandlers, HasMouseUpHandlers, HasMouseWheelHandlers {

	/* The widget displaying the value */
	private TextBoxWidget widget;
	private IValueConverter<DataType> valueConverter;

	/**
	 * Constructs a new text box widget that maintains a typed value
	 * 
	 * @param valueConverter
	 */
	public TypedPositionFieldWidget(IValueConverter<DataType> valueConverter) {
		super();

		this.valueConverter = valueConverter;
		this.widget = new TextBoxWidget();
		EventHandler eventHandler = new EventHandler();
		this.widget.addValueChangeHandler(eventHandler);


		/* The Text Box is the parent widget */
		super.initWidget(widget);
		init();
	}

	// ========================================================================
	// ===================== HAS NAME
	// ========================================================================

	/**
	 * @see TextBoxWidget#getName()
	 */
	@Override
	public String getName() {
		return widget.getName();
	}

	/**
	 * @see TextBoxWidget#setName(String)
	 */
	@Override
	public void setName(String name) {
		widget.setName(name);
	}

	// ========================================================================
	// ===================== HAS DIRECTION
	// ========================================================================

	/**
	 * @see TextBoxWidget#getDirection()
	 */
	@Override
	public Direction getDirection() {
		return widget.getDirection();
	}

	/**
	 * @see TextBoxWidget#setDirection(Direction)
	 */
	@Override
	public void setDirection(Direction direction) {
		widget.setDirection(direction);
	}

	// ========================================================================
	// ===================== HAS TEXT
	// ========================================================================

	/**
	 * @see TextBoxWidget#getText()
	 */
	@Override
	public String getText() {
		return widget.getText();
	}

	/**
	 * @see TextBoxWidget#setText(String)
	 */
	@Override
	public void setText(String text) {
		widget.setText(text);
	}

	// ========================================================================
	// ===================== EVENT HANDLERS
	// ========================================================================

	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}

	@Override
	public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
		return addDomHandler(handler, KeyPressEvent.getType());
	}

	@Override
	public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
		return addDomHandler(handler, KeyUpEvent.getType());
	}

	@Override
	public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
		return addDomHandler(handler, KeyDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}

	// ========================================================================
	// ===================== HAS VALUE
	// ========================================================================

	/**
	 * Gets the typed value, or null if there was an error parsing the value
	 */
	@Override
	public DataType getValue() {
		DataType value = null;

		try {
			value = valueConverter.getTypedValue(widget.getText());
		} catch (ValueFormatException vfe) {
		}

		return value;
	}

	@Override
	public void setValue(DataType value) {
		this.setValue(value, false);
	}

	@Override
	public void setValue(DataType value, boolean fireEvents) {
		widget.setValue(valueConverter.getStringValue(value), fireEvents);
		this.updateWidgetState();
	}

	@Override
	public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
		return this.addHandler(handler, ValueChangeEvent.getType());
	}

	// ========================================================================
	// ===================== FOCUSABLE
	// ========================================================================

	/**
	 * @see TextBoxWidget#getTabIndex()
	 */
	@Override
	public int getTabIndex() {
		return widget.getTabIndex();
	}

	/**
	 * @see TextBoxWidget#setTabIndex(int)
	 */
	@Override
	public void setTabIndex(int index) {
		widget.setTabIndex(index);
	}

	/**
	 * @see TextBoxWidget#setAccessKey(char)
	 */
	@Override
	public void setAccessKey(char key) {
		widget.setAccessKey(key);
	}

	/**
	 * @see TextBoxWidget#setFocus(boolean)
	 */
	@Override
	public void setFocus(boolean focused) {
		widget.setFocus(focused);
	}

	// ========================================================================
	// ===================== HAS ALL FOCUS HANDLERS
	// ========================================================================

	@Override
	public HandlerRegistration addFocusHandler(FocusHandler handler) {
		return this.addDomHandler(handler, FocusEvent.getType());
	}

	@Override
	public HandlerRegistration addBlurHandler(BlurHandler handler) {
		return this.addDomHandler(handler, BlurEvent.getType());
	}

	// ========================================================================
	// ===================== DATA TYPE WIDGET ABSTRACT METHODS
	// ========================================================================

	@Override
	public boolean isValidValue() {
		boolean valid = false;
		try {
			valueConverter.getTypedValue(widget.getText());
			valid = true;
		} catch (ValueFormatException vfe) {
		}

		return valid;
	}

	@Override
	public String getTextValue() {
		return this.getText();
	}

	@Override
	public void setTextValue(String textValue) {
		widget.setText(textValue);
		this.updateWidgetState();
	}

	/**
	 * @see TextBoxWidget#isReadOnly()
	 */
	@Override
	public boolean isReadOnly() {
		return widget.isReadOnly();
	}

	/**
	 * @see TextBoxWidget#setReadOnly(boolean)
	 */
	@Override
	public void setReadOnly(boolean readOnly) {
		widget.setReadOnly(readOnly);
	}

	/**
	 * @see TextBoxWidget#isEnabled()
	 */
	@Override
	public boolean isEnabled() {
		return widget.isEnabled();
	}

	/**
	 * @see TextBoxWidget#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		widget.setEnabled(enabled);
	}

	/**
	 * Add or remove the error style based on the error state
	 */
	protected void updateStyle() {
		if (this.isInErrorState())
			widget.addStyleDependentName(ERROR_STYLE);
		else
			widget.removeStyleDependentName(ERROR_STYLE);
	}

	@Override
	public String getCurrentToolTip() {
		return widget.getTitle();
	}

	@Override
	protected void setCurrentToolTip(String toolTip) {
		widget.setTitle(toolTip);
	}

	// ========================================================================
	// ===================== TEXT BOX DELEGATE METHODS
	// ========================================================================

	/**
	 * @see TextBoxWidget#getMaxLength()
	 */
	public int getMaxLength() {
		return widget.getMaxLength();
	}

	/**
	 * @see TextBoxWidget#setMaxLength(int)
	 */
	public void setMaxLength(int length) {
		widget.setMaxLength(length);
	}

	/**
	 * @see TextBoxWidget#getVisibleLength()
	 */
	public int getVisibleLength() {
		return widget.getVisibleLength();
	}

	/**
	 * @see TextBoxWidget#setVisibleLength(int)
	 */
	public void setVisibleLength(int length) {
		widget.setVisibleLength(length);
	}

	/**
	 * @see TextBoxWidget#cancelKey()
	 */
	public void cancelKey() {
		widget.cancelKey();
	}

	/**
	 * @see TextBoxWidget#getCursorPos()
	 */
	public int getCursorPos() {
		return widget.getCursorPos();
	}

	/**
	 * @see TextBoxWidget#setCursorPos(int)
	 */
	public void setCursorPos(int pos) {
		widget.setCursorPos(pos);
	}

	/**
	 * @see TextBoxWidget#getSelectedText()
	 */
	public String getSelectedText() {
		return widget.getSelectedText();
	}

	/**
	 * @see TextBoxWidget#getSelectionLength()
	 */
	public int getSelectionLength() {
		return widget.getSelectionLength();
	}

	/**
	 * @see TextBoxWidget#setSelectionRange(int, int)
	 */
	public void setSelectionRange(int pos, int length) {
		widget.setSelectionRange(pos, length);
	}

	/**
	 * @see TextBoxWidget#selectAll()
	 */
	public void selectAll() {
		widget.selectAll();
	}

	/**
	 * @see TextBoxWidget#setTextAlignment(TextAlignConstant)
	 */
	public void setTextAlignment(TextAlignConstant align) {
		widget.setTextAlignment(align);
	}

	// ========================================================================
	// ===================== EVENT DELEGATOR
	// ========================================================================

	/*
	 * Inner class that delegates the value change events to this class
	 */
	private class EventHandler implements ValueChangeHandler<String> {

		@Override
		public void onValueChange(ValueChangeEvent<String> event) {
			updateWidgetState();
			DataType value = null;

			try {
				/* Try getting the converted value */
				value = valueConverter.getTypedValue(event.getValue());
				String formattedValue = valueConverter.getStringValue(value);
				widget.setValue(formattedValue);
			} catch (ValueFormatException vfe) {
			}

			ValueChangeEvent.fire(TypedPositionFieldWidget.this, value);
		}
	}

	private void init() {
		final TextBox xField = new TextBox();
		xField.setVisibleLength(2);
		final TextBox yField = new TextBox();
		yField.setVisibleLength(2);
		final Grid theGrid = new Grid(1, 1);
		theGrid.addStyleName("theGrid");
		theGrid.setBorderWidth(1);
		theGrid.setSize("320px", "180px");

		//RootPanel.get("nameFieldContainer").add(positionField);

		// Create the popup dialog box
		final DialogBox dialogBox = new DialogBox();
		dialogBox.setAnimationEnabled(true);
		final Button closeButton = new Button("Save");
		// We can set the id of a widget by accessing its Element
		closeButton.getElement().setId("closeButton");
		VerticalPanel dialogVPanel = new VerticalPanel();
		dialogVPanel.addStyleName("dialogVPanel");
		HorizontalPanel dimension = new HorizontalPanel();
		dimension.add(xField);
		dimension.add(new HTML("<b>x</b>"));
		dimension.add(yField);
		dialogVPanel.add(dimension);
		dialogVPanel.add(theGrid);
		dialogVPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		dialogVPanel.add(closeButton);
		dialogBox.setWidget(dialogVPanel);

		closeButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				String cells = "";
				for(int i = 0; i < theGrid.getRowCount(); i++) {
					for(int j = 0; j < theGrid.getCellCount(0); j++) {
						if(theGrid.getCellFormatter().getStyleName(i, j).equals("cellSelect")) {
							if(cells.equals(""))
								cells = "(" + (j + 1) + "," + (i + 1) + ")";
							else
								cells += ",(" + (j + 1) + "," + (i + 1) + ")";
						}
					}
				}
				widget.setText(
						"{" + cells + "}"
						+ "/" + xField.getText()
						+ "x" + yField.getText());
				dialogBox.hide();
			}
		});

		class DimensionHandler implements ChangeHandler, KeyUpHandler {

			@Override
			public void onChange(ChangeEvent event) {
				theGrid.resize(0, 0);
				theGrid.resize(Integer.parseInt(yField.getText()), Integer.parseInt(xField.getText()));
			}

			@Override
			public void onKeyUp(KeyUpEvent event) {
				theGrid.resize(0, 0);
				theGrid.resize(Integer.parseInt(yField.getText()), Integer.parseInt(xField.getText()));
			}
			
		}

		class GridHandler implements ClickHandler {

			@Override
			public void onClick(ClickEvent event) {
				Cell cell = theGrid.getCellForEvent(event);
				int x = cell.getRowIndex();
				int y = cell.getCellIndex();
				if(theGrid.getCellFormatter().getStyleName(x, y).equals("cellSelect")) {
					theGrid.getCellFormatter().removeStyleName(x, y, "cellSelect");
				} else {
					theGrid.getCellFormatter().setStyleName(x, y, "cellSelect");
				}
			}
		}

		class PositionHandler implements ClickHandler, FocusHandler {

			public void onClick(ClickEvent event) {
				openDialogBox();
			}
			public void onFocus(FocusEvent event) {
				openDialogBox();
			}

			private void openDialogBox() {

				dialogBox.setText("Overlay Position");
				if( widget.getText() != null && widget.getText().matches("{((\\(\\d+,\\d+\\),)*\\(\\d+,\\d+\\)|)}/\\d+x\\d+") ) {
					xField.setText(widget.getText().substring(widget.getText().indexOf("/") + 1, widget.getText().indexOf("x")));
					yField.setText(widget.getText().substring(widget.getText().indexOf("x") + 1));
				} else {
					xField.setText("1");
					yField.setText("1");
				}
				theGrid.resize(0, 0);
				theGrid.resize(Integer.parseInt(yField.getText()), Integer.parseInt(xField.getText()));

				if( widget.getText() != null && widget.getText().matches("{((\\(\\d+,\\d+\\),)*\\(\\d+,\\d+\\)|)}/\\d+x\\d+") ) {
					String[] cells = widget.getText().substring(widget.getText().indexOf("{") + 2, widget.getText().indexOf("}") - 1).split("\\),\\(");
				
					for(String cell : cells) {
						String[] c = cell.split(",");
						int x = Integer.parseInt(c[0]) - 1;
						int y = Integer.parseInt(c[1]) - 1;
						theGrid.getCellFormatter().setStyleName(y, x, "cellSelect");
					}
				}
				
				dialogBox.center();
			}
		}

		// Add a handler to send the name to the server
		PositionHandler handler = new PositionHandler();
		widget.addClickHandler(handler);
		DimensionHandler dHandler = new DimensionHandler();
		xField.addChangeHandler(dHandler);
		yField.addChangeHandler(dHandler);
		xField.addKeyUpHandler(dHandler);
		yField.addKeyUpHandler(dHandler);
		GridHandler gh = new GridHandler();
		theGrid.addClickHandler(gh);
	}
}
