/*
 * Created on May 4, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.titlelist.client;


/**
 * The permissions used by the content component, and verification of the current user permissions
 * 
 * @author Vijay Silva
 */
public final class Permissions {

	/* Cannot instantiate */
	private Permissions() {
	}

	/**
	 * View permission for a title list
	 */
	public static final String TITLELIST_VIEW = "AssetListManagement_View";

	/**
	 * Create permission for a title list
	 */
	public static final String TITLELIST_CREATE = "AssetListManagement_Create";

	/**
	 * Modify permission for a title list
	 */
	public static final String TITLELIST_MODIFY = "AssetListManagement_Modify";

	/**
	 * Delete permission for a title list
	 */
	public static final String TITLELIST_DELETE = "AssetListManagement_Delete";

}
