package com.tandbergtv.cms.portal.content.titlelist.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.titlelist.client.services.AddAssetToTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.services.RunTemplate;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListDeleteService;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListXportService;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListCreatePanel;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListsPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class TitleListComponent extends ComponentBase {
	/** The Title List Component Name */
	public static final String COMPONENT_NAME = "Title List Management";

	/* The values for the user properties loaded during initialization */
	private String spec = "";
	private final TitleListComponentConstants constants;

	/**
	 * Constructor
	 */
	public TitleListComponent() {
		constants = GWT.create(TitleListComponentConstants.class);
	}

	// ========================================================================
	// ===================== COMPONENT METHODS
	// ========================================================================

	@Override
	public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink,
			ServiceLoader serviceLoader, Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
		spec = info.get(PreferenceKeys.SPECIFICATION_NAME);
	}

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {
		List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();

		return portletFactories;
	}

	@Override
	@SuppressWarnings("unchecked")
	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		if (clazz.getName().equalsIgnoreCase(ITitleListService.class.getName())) {
			return (List<E>) getTitleListServices();
		} else if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
			List<ITitleService> listServices = new ArrayList<ITitleService>();
			if (ClientAuthorizationManager.isAuthorized(Permissions.TITLELIST_MODIFY)) {
				listServices.add(new AddAssetToTitleList());
			}
			return (List<E>) listServices;
		}

		return null;
	}

	private List<ITitleListService> getTitleListServices() {
		List<ITitleListService> titleListServices = new ArrayList<ITitleListService>();
		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLELIST_DELETE)) {
			titleListServices.add(new TitleListDeleteService());
		}

		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLELIST_VIEW, Permissions.TITLELIST_MODIFY)) {
			titleListServices.add(new TitleListXportService());
		}

		if (ClientAuthorizationManager.isAuthorized(com.tandbergtv.cms.portal.content.client.Permissions.WORKORDER_CREATE)) {
			titleListServices.add(new RunTemplate());
		}

		return titleListServices;
	}

	// ========================================================================
	// ===================== TITLE LIST - MENU ITEMS
	// ========================================================================

	@Override
	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

		/* Build the menu group: 'Content' */
		List<MenuItemBase> childMenuItems = new ArrayList<MenuItemBase>();
		MenuItemProxy rootMenuItem = new MenuItemProxy(constants.menuItemContent(), childMenuItems);

		/* Build the menu items for the 'title list' entity */
		buildTitleListMenuItems(rootMenuItem);

		/* Always add the group menu item */
		tabs.add(rootMenuItem);

		return tabs;
	}

	// ========================================================================
	// ===================== CONTENT - TITLE LIST MENU ITEMS
	// ========================================================================

	/*
	 * Build the menu items used to manage title lists
	 */
	private void buildTitleListMenuItems(MenuItemProxy parentMenuItem) {
		/* Always add the group menu item */
		List<MenuItemBase> titleListsGroup = new ArrayList<MenuItemBase>();
		String displayName = constants.menuItemTitleList();
		GroupMenuItem menuItem = new GroupMenuItem("TitleLists", displayName, titleListsGroup);
		parentMenuItem.getItems().add(menuItem);

		// if the user does not have view or create permissions return back.
		if (ClientAuthorizationManager.isAuthorized(Permissions.TITLELIST_VIEW)) {
			if (ClientAuthorizationManager.isAuthorized(Permissions.TITLELIST_VIEW)) {
				final TitleListsPanel titleListPanel = new TitleListsPanel(spec, ClientAuthorizationManager
						.getSecurity(), serviceLoader);
				displayName = constants.menuItemTitleList();
				WidgetMenuItem titleListsView = new WidgetMenuItem("TitleLists", displayName, new WidgetFactory() {
					public Widget getInstance() {
						return titleListPanel;
					}

					public void release(Widget widget) {
					}
				}, titleListPanel.getAnchorChangeListener());
				titleListPanel.setReverseAnchorChangeListener(titleListsView.getReverseAnchorChangeListener());
				
				parentMenuItem.getItems().add(titleListsView);
			}
			
		
		}
	}

	// ========================================================================
	// ===================== COMPONENT PREFERENCES
	// ========================================================================

	/**
	 * Get the name of the default specification to use when rendering the title
	 * list component pages
	 */
	public String getSpecificationName() {
		return this.spec;
	}

    @Override
    public String getName() {
        return "TITLE_LIST";
    }

    @Override
    public String getDisplayName() {
        return constants.componentDisplayName();
    }

}
