/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.titlelist.client.imageeditor;

import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.title.model.UIImageEditor;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author Daniel Silva
 */
public class ImageWidget extends Composite implements INeptuneWidget {

	private static final String GET_IMAGE_JSP_PATH = "/portal/cms_titlelistmgmt_ui/jsps/get_image.jsp";
	private static final String EDIT_IMAGE_LIC_KEY = "EditImageLicense";

	private final ImageEditorServiceAsync imageEditorService = GWT.create( ImageEditorService.class );
	
	private TitleListConstants constants = (TitleListConstants) GWT.create(TitleListConstants.class);

	private Image image;

	private VerticalPanel mainPanel;

	private SaveImageRequest saveImageRequest;
	
	private boolean removeImage = false;
	
	/* Parameters used for initializing NetImager */
	private static String address;
	private static String organization;
	private static String company;
	private static String licenseString1;
	private static String licenseString2;
	private static boolean isEditlicense;

	
	/**
	 * Constructor
	 */
	public ImageWidget( SaveImageRequest saveImageRequest ) {
		initializeWidget( saveImageRequest );
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget( SaveImageRequest saveImageRequest ) {

		this.saveImageRequest = saveImageRequest;
		
		imageEditorService.getSettings(new NeptuneAsyncCallback<UIImageEditor>() {
			/* Success getting settings */
			public void onNeptuneSuccess(UIImageEditor confSettings) {
				Map<String,String>parms = confSettings.getParameters();
				address = parms.get("address") == null ? "" : parms.get("address").trim();
				organization = parms.get("organization") == null ? "" : parms.get("organization").trim();
				company = parms.get("company") == null ? "" : parms.get("company").trim();
				licenseString1 = parms.get("license_1") == null ? "" : parms.get("license_1").trim();
				licenseString2 = parms.get("license_2") == null ? "" : parms.get("license_2").trim();
				isEditlicense = getBooleanValue(parms.get(EDIT_IMAGE_LIC_KEY).trim());
			};

			/* Failure getting conf settings from backend */
			public void onNeptuneFailure(Throwable caught) {
				Window.alert( "Failed to retrieve NetImage settings : " + caught.getMessage()
						+ "\n Please try again." );
			};
		});	

		Button uploadImageButton = new Button( constants.upload() );
		uploadImageButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		uploadImageButton.addStyleName(StyleNames.STYLE_EB_BTN);
		uploadImageButton.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
		Button removeImageButton = new Button( constants.remove() );
		removeImageButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		removeImageButton.addStyleName(StyleNames.STYLE_EB_BTN);
		removeImageButton.addStyleName(StyleNames.STYLE_DELETE_BUTTON_ICON);
		uploadImageButton.addClickHandler( new ClickHandler() {
			public void onClick( ClickEvent event ) {
				loadUploadDialog();
			}
		} );
		
		removeImageButton.addClickHandler( new ClickHandler() {
			public void onClick( ClickEvent event ) {
				removeImage();
			}
		} );
		
		image = new Image();
		image.setHeight( "80px" );
		image.setUrl( generateUrl() );

		mainPanel = new VerticalPanel();
		mainPanel.add( image );
		Label vertSpace = new Label();
		vertSpace.setHeight( "5px" );
		mainPanel.add( vertSpace );
		
		HorizontalPanel buttonsPanel = new HorizontalPanel(); 
		buttonsPanel.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
		buttonsPanel.add( uploadImageButton );
		Label horSpace = new Label();
		horSpace.setWidth( "5px" );
		buttonsPanel.add( horSpace );
		buttonsPanel.add( removeImageButton );
		
		mainPanel.add( buttonsPanel );

		this.initWidget( mainPanel );
	}
	
	private boolean getBooleanValue(String propertyValue) {
		if (propertyValue == null)
			return false;
		return Boolean.parseBoolean(propertyValue);
	}
	
	private void loadUploadDialog() {
		imageEditorService.putImageInSession( ImageWidget.this.saveImageRequest,
			new AsyncCallback<Void>() {

				@Override
				public void onFailure(Throwable caught) {
					Window.alert( "Failed to store image in session : putImageInSession RPC Failure : " + caught.getMessage()
							+ "\n Please try again." );
				}

				@Override
				public void onSuccess(Void result) {
					final UploadImageDialogBox uploadImageDialogBox = new UploadImageDialogBox(
						new AsyncCallback<Void>() {

							@Override
							public void onFailure( Throwable caught ) {
								Window.alert( "Failed to load the upload image dialog : " + caught.getMessage()
										+ "\n Please try again." );
							}

							@Override
							public void onSuccess( Void result ) {
								ImageWidget.this.image.setUrl( ImageWidget.this.generateUrl() );
							}
						} 
					);					
					uploadImageDialogBox.center();
					uploadImageDialogBox.setSaveImageRequest( ImageWidget.this.saveImageRequest );

					if (isEditlicense == true)
						loadUrl(generateUrl(), address, organization, company, licenseString1, licenseString2);
					else
						uploadImage(generateUrl(), address, organization, company, licenseString1, licenseString2);
				}
			}
		);
	}		
	
	private void removeImage() {
		saveImageRequest.setImageDataBase64( null );
		removeImage = true;

		imageEditorService.putImageInSession( ImageWidget.this.saveImageRequest,
			new AsyncCallback<Void>() {

				@Override
				public void onFailure(Throwable caught) {
					Window.alert( "Failed to store image in session : putImageInSession RPC Failure : " + caught.getMessage()
							+ "\n Please try again." );
					removeImage = false;
				}

				@Override
				public void onSuccess(Void result) {
					ImageWidget.this.image.setUrl( ImageWidget.this.generateUrl() );
					removeImage = false;
				}
			}
		);
	}	

	private String generateUrl() {
		StringBuffer imageUrl = new StringBuffer( Window.Location.getProtocol() + "//" + Window.Location.getHost()
				+ GET_IMAGE_JSP_PATH );
		
		imageUrl.append( "?key=" + Random.nextInt() ); // parameter just to create a different URL
		if ( saveImageRequest.getAssetListElementId() != null ) {
			imageUrl.append( "&assetListId=" + saveImageRequest.getAssetListId() );
			imageUrl.append( "&assetListElementId=" + saveImageRequest.getAssetListElementId() );
			imageUrl.append( "&metadataFieldName=" + saveImageRequest.getMetadataFieldName() );
			if ( removeImage ) {
				imageUrl.append( "&removeImage=yes" );
			}
		} else if ( saveImageRequest.getAssetListId() != null ) {
			imageUrl.append( "&assetListId=" + saveImageRequest.getAssetListId() );
			imageUrl.append( "&metadataFieldName=" + saveImageRequest.getMetadataFieldName() );
			if ( removeImage ) {
				imageUrl.append( "&removeImage=yes" );
			}
		}
		
		return imageUrl.toString();
	}

	public void setImage( Image image ) {
		this.image = image;
	}

	public Image getImage() {
		return image;
	}

	// =============================================================================
	// ===================== JSNI
	// ==================================================
	// =============================================================================



	public static native void loadUrl(String imageUrl, String address, String organization, String company, String licenseString1, String licenseString2) /*-{
    	$wnd.setData(imageUrl, address, organization, company, licenseString1, licenseString2);
    	$wnd.editImage();
    	
    }-*/;

	public static native void uploadImage(String imageUrl, String address, String organization, String company, String licenseString1, String licenseString2) /*-{
		$wnd.setData(imageUrl, address, organization, company, licenseString1, licenseString2);
		$wnd.uploadImage();
	
	}-*/;

	
	public void setSaveImageRequest( SaveImageRequest saveImageRequest ) {
		this.saveImageRequest = saveImageRequest;
	}

	public SaveImageRequest getSaveImageRequest() {
		return saveImageRequest;
	}

}
