package com.tandbergtv.cms.portal.content.titlelist.client.imageeditor;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * A Image Box Widget to display an image from an URL.
 * 
 * @author Daniel Silva
 */
public class TypedImageBoxWidget<DataType> extends DataTypeWidget<DataType> {

	/* The widget displaying the image */
	private ImageWidget widget;
	private IValueConverter<DataType> valueConverter;
	private String url;

	/**
	 * Constructs a new image box widget that displays an image
	 * 
	 * @param valueConverter
	 */
	public TypedImageBoxWidget(IValueConverter<DataType> valueConverter, SaveImageRequest saveImageRequest) {
		super();

		this.valueConverter = valueConverter;
		this.widget = new ImageWidget( saveImageRequest );

		/* The ImageWidget is the parent widget */
		super.initWidget(widget);
	}

	// ========================================================================
	// ===================== HAS VALUE
	// ========================================================================

	/**
	 * Gets the url value, or null if there was an error parsing the value
	 */
	@Override
	public DataType getValue() {
		DataType value = null;

		try {
			value = valueConverter.getTypedValue(this.url);
		} catch (ValueFormatException vfe) {
		}

		return value;
	}

	@Override
	public void setValue(DataType value) {
		this.setValue(value, false);
	}

	@Override
	public void setValue(DataType value, boolean fireEvents) {
		widget.getImage().setUrl(valueConverter.getStringValue(value));
		this.updateWidgetState();
	}

	@Override
	public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
		return this.addHandler(handler, ValueChangeEvent.getType());
	}
	
	@Override
	public String getTextValue() {
		return widget.getSaveImageRequest().getImageDataBase64();
	}
	
	@Override
	public void setTextValue( String textValue ) {
		widget.getSaveImageRequest().setImageDataBase64( textValue );
	}	

	@Override
	public boolean isEnabled() {
		return true;
	}
	
	@Override
	public void setEnabled( boolean enabled ) {
	}

	@Override
	public boolean isReadOnly() {
		return false;
	}
	
	@Override
	public void setReadOnly( boolean readOnly ) {
	}
	

	// ========================================================================
	// ===================== FOCUSABLE
	// ========================================================================

	@Override
	public int getTabIndex() {
		return 100;
	}

	@Override
	public void setTabIndex(int index) {
	}

	@Override
	public void setAccessKey(char key) {
	}

	@Override
	public void setFocus(boolean focused) {
	}

	// ========================================================================
	// ===================== HAS ALL FOCUS HANDLERS
	// ========================================================================

	@Override
	public HandlerRegistration addFocusHandler(FocusHandler handler) {
		return this.addDomHandler(handler, FocusEvent.getType());
	}

	@Override
	public HandlerRegistration addBlurHandler(BlurHandler handler) {
		return this.addDomHandler(handler, BlurEvent.getType());
	}

	// ========================================================================
	// ===================== DATA TYPE WIDGET ABSTRACT METHODS
	// ========================================================================

	@Override
	public boolean isValidValue() {
		boolean valid = false;
		try {
			valueConverter.getTypedValue(this.url);
			valid = true;
		} catch (ValueFormatException vfe) {
		}

		return valid;
	}

	/**
	 * Add or remove the error style based on the error state
	 */
	protected void updateStyle() {
		if (this.isInErrorState())
			widget.addStyleDependentName(ERROR_STYLE);
		else
			widget.removeStyleDependentName(ERROR_STYLE);
	}

	@Override
	public String getCurrentToolTip() {
		return widget.getTitle();
	}

	@Override
	protected void setCurrentToolTip(String toolTip) {
		widget.setTitle(toolTip);
	}
}
