package com.tandbergtv.cms.portal.content.titlelist.client.imageeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorServiceAsync;

public class UploadImageDialogBox extends DialogBox {

	private final ImageEditorServiceAsync imageEditorService = GWT
			.create(ImageEditorService.class);
	
	private TitleListConstants constants = (TitleListConstants) GWT.create(TitleListConstants.class);
	
	private SaveImageRequest saveImageRequest;
	
	private AsyncCallback<Void> callback;
	

	public UploadImageDialogBox( AsyncCallback<Void> callback ) {
		super(false, true);
		this.callback = callback;
		init();
	}
	
	public void init() {
		// Set the dialog box's caption.
		setText(constants.uploadImage());

		VerticalPanel verticalPanel = new VerticalPanel();
		
		final HTML appletHTML = new HTML();
		String strAppletHTML = getAppletCode();
		appletHTML.setHTML(strAppletHTML);
		
		verticalPanel.add(appletHTML);

		HorizontalPanel horizontalPanel = new HorizontalPanel();
		horizontalPanel.setSpacing(5);
		
		TextArea saveImageContent = new TextArea();
		saveImageContent.setVisible(false);
		horizontalPanel.add(saveImageContent);
		
		Button ok = new Button("OK");
		ok.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				String imageDataBase64 = getImageDataBase64( getImageFileName());
				
				if (saveImageRequest != null) {
					saveImageRequest.setImageDataBase64(imageDataBase64);
					
					imageEditorService.putImageInSession(saveImageRequest,
						new AsyncCallback<Void>() {

							@Override
							public void onFailure(Throwable caught) {
								if ( callback != null ) {
									callback.onFailure( null );
								}
							}

							@Override
							public void onSuccess(Void result) {
								UploadImageDialogBox.this.hide();
								if ( callback != null ) {
									callback.onSuccess( null );
								}
							}

						}
					);
				}
			}
		});
		horizontalPanel.add(ok);

		Button cancel = new Button(constants.cancelButtonName());
		cancel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				UploadImageDialogBox.this.hide();
			}
		});
		horizontalPanel.add(cancel);

		verticalPanel.add(horizontalPanel);

		// DialogBox is a SimplePanel, so you have to set its widget property to
		// whatever you want its contents to be.
		setWidget(verticalPanel);
		
	}

	public static native String getAppletCode() /*-{
		var NetImager;
		NetImager = new $wnd.netimager("NetImager");
		NetImager.width = 800;
		NetImager.height = 600;

		return NetImager.getAppletCode();
	}-*/;

	public static native String getImageDataBase64( String fileName ) /*-{
//		$wnd.alert("In getImageDataBase64() : fileName : " + fileName);
		var savedImageData;
		if ($doc.NetImager) {
			$doc.NetImager.setFileName(fileName);
			savedImageData = $doc.NetImager.GetBase64();
		}

		return savedImageData;
	}-*/;

	public static native String getImageFileName() /*-{
		var imageFileName;
		if ($doc.NetImager) {
			imageFileName = $doc.NetImager.getFileName();
		}
		return imageFileName;
	}-*/;
	
	/**
	 * @return the saveImageRequest
	 */
	public SaveImageRequest getSaveImageRequest() {
		return saveImageRequest;
	}

	/**
	 * @param saveImageRequest the saveImageRequest to set
	 */
	public void setSaveImageRequest(SaveImageRequest saveImageRequest) {
		this.saveImageRequest = saveImageRequest;
	}
	
}
