package com.tandbergtv.cms.portal.content.titlelist.client.model;

import java.io.Serializable;

/**
 * Class used to store the image data and information to be sent from the client
 * to the server
 * 
 * @author Daniel Silva
 * 
 */
public class SaveImageRequest implements Serializable {

	private static final long serialVersionUID = -5244603064657807629L;

	private String imageDataBase64;
	private Long assetListElementId;
	private Long assetListId;
	private String metadataFieldName;

	/**
	 * The constructor
	 */
	public SaveImageRequest() {
		super();
	}

	/**
	 * Get the Bas64 representation of the image
	 * 
	 * @return the imageDataBase64
	 */
	public String getImageDataBase64() {
		return imageDataBase64;
	}

	/**
	 * Set the Bas64 representation of the image
	 * 
	 * @param imageDataBase64
	 *            the imageDataBase64 to set
	 */
	public void setImageDataBase64( String imageDataBase64 ) {
		this.imageDataBase64 = imageDataBase64;
	}

	/**
	 * Get the asset list element id
	 * 
	 * @return the assetId
	 */
	public Long getAssetListElementId() {
		return assetListElementId;
	}

	/**
	 * Set the asset list element id
	 * 
	 * @param assetId
	 *            the assetListElementId to set
	 */
	public void setAssetListElementId( Long assetListElementId ) {
		this.assetListElementId = assetListElementId;
	}

	/**
	 * Get the asset list id
	 * 
	 * @return the assetListId
	 */
	public Long getAssetListId() {
		return assetListId;
	}

	/**
	 * Set the asset list id
	 * 
	 * @param assetListId
	 *            the assetListId to set
	 */
	public void setAssetListId( Long assetListId ) {
		this.assetListId = assetListId;
	}

	/**
	 * Get the metadata field name
	 * 
	 * @return the metadata field name
	 */
	public String getMetadataFieldName() {
		return metadataFieldName;
	}
	
	/**
	 * Set the metadata field name
	 * 
	 * @param metadataFieldName
	 *            the metadata field name
	 */
	public void setMetadataFieldName( String metadataFieldName ) {
		this.metadataFieldName = metadataFieldName;
	}	

}
