package com.tandbergtv.cms.portal.content.titlelist.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Class to map the AssetListType server class to the UI
 * 
 * @author dpsilva
 * 
 */
public class UiAssetListType implements IsSerializable {

	private String name;
	private String displayName;
	private List<UiMetadataField> listMetadata;
	private List<UiMetadataField> elementMetadata;
	
	/**
	 * Default constructor
	 */
	public UiAssetListType() {
		this( "", "" );
	}

	/**
	 * Constructor
	 * 
	 * @param name
	 *            the name
	 * @param displayName
	 *            the display name
	 */
	public UiAssetListType( String name, String displayName ) {
		this.name = name;
		this.displayName = displayName;
		this.listMetadata = new ArrayList<UiMetadataField>();
		this.elementMetadata = new ArrayList<UiMetadataField>();
	}

	/**
	 * Set the name
	 * 
	 * @param name
	 *            the name
	 */
	public void setName( String name ) {
		this.name = name;
	}

	/**
	 * Get the name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the display name
	 * 
	 * @param displayName
	 *            the display name
	 */
	public void setDisplayName( String displayName ) {
		this.displayName = displayName;
	}

	/**
	 * Get the display name
	 * 
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Set the list of metadata fields for the title list
	 * 
	 * @param listMetadata
	 *            the list of metadata fields for the title list
	 */
	public void setListMetadata( List<UiMetadataField> listMetadata ) {
		this.listMetadata = listMetadata;
		if ( this.listMetadata == null ) {
			this.listMetadata = new ArrayList<UiMetadataField>();
		}
	}

	/**
	 * Get the list of metadata fields for the title list
	 * 
	 * @return the list of metadata fields for the title list
	 */
	public List<UiMetadataField> getListMetadata() {
		return listMetadata;
	}

	/**
	 * Set the list of metadata fields for the assets
	 * 
	 * @param elementMetadata
	 *            the list of metadata fields for the assets
	 */
	public void setElementMetadata( List<UiMetadataField> elementMetadata ) {
		this.elementMetadata = elementMetadata;
		if ( this.elementMetadata == null ) {
			this.elementMetadata = new ArrayList<UiMetadataField>();
		}
	}

	/**
	 * Get the list of metadata fields for the assets
	 * 
	 * @return the list of metadata fields for the assets
	 */
	public List<UiMetadataField> getElementMetadata() {
		return elementMetadata;
	}

}
