package com.tandbergtv.cms.portal.content.titlelist.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;

/**
 * Class to map the AssetListAssetMap server class to be used on client side
 * 
 * @author dpsilva
 */
public class UiAssetMap implements IsSerializable {

	private long id;
	private Long titleId;
	private UiTitle title;
	private UiAsset asset;
	private List<UiMetadataField> metadataFields;

	public UiAssetMap() {
		init( -1, new UiTitle(), new UiAsset() );
	}

	public UiAssetMap(long id) {
		init( id, new UiTitle(), new UiAsset() );
	}

	/**
	 * Constructor
	 * 
	 * @param id
	 * 			  the list element id
	 * @param title
	 *            the ui title
	 */
	public UiAssetMap( long id, UiTitle title ) {
		init( id, title, new UiAsset() );
	}

	/**
	 * Constructor
	 * 
	 * @param id
	 * 			  the list element id
	 * @param titleId
	 *            the title id
	 * @param partnerId
	 *            the partnerId id
	 * @param asset
	 *            the ui asset
	 */
	public UiAssetMap( long id, Long titleId, Long partnerId, UiAsset asset ) {
		this.titleId = titleId;
		init( id, new UiTitle( titleId, partnerId ), asset );
	}

	/**
	 * Constructor
	 * 
	 * @param id
	 * 			  the list element id
	 * @param title
	 *            the ui title
	 * @param asset
	 *            the ui asset
	 */
	public UiAssetMap( long id, UiTitle title, UiAsset asset ) {
		init( id, title, asset );
	}

	private void init( long id, UiTitle title, UiAsset asset ) {
		this.id = id;
		this.title = title;
		this.asset = asset;
		this.metadataFields = new ArrayList<UiMetadataField>();
	}

	/**
	 * @return the list element id
	 */
	public long getId() {
		return id;
	}

	/**
	 * Set the ui title
	 * 
	 * @param title
	 *            the ui title
	 */
	public void setTitle( UiTitle title ) {
		this.title = title;
	}

	/**
	 * Get the ui title
	 * 
	 * @return the ui title
	 */
	public UiTitle getTitle() {
		return title;
	}

	/**
	 * Set the ui asset
	 * 
	 * @param asset
	 *            the ui assset
	 */
	public void setAsset( UiAsset asset ) {
		this.asset = asset;
	}

	/**
	 * Get the ui asset
	 * 
	 * @return the ui asset
	 */
	public UiAsset getAsset() {
		return asset;
	}

	/**
	 * Set the title id
	 * 
	 * @return the title id
	 */
	public Long getTitleId() {
		return titleId;
	}

	/**
	 * Set the list of metadata fields
	 * 
	 * @param metadataFields
	 *            the list of metadata fields
	 */
	public void setMetadataFields( List<UiMetadataField> metadataFields ) {
		this.metadataFields = metadataFields;
	}

	/**
	 * Get the list of metadata fields
	 * 
	 * @return the list of metadata fields
	 */
	public List<UiMetadataField> getMetadataFields() {
		return metadataFields;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (id ^ (id >>> 32));
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof UiAssetMap))
			return false;
		UiAssetMap other = (UiAssetMap) obj;
		if (id != other.id)
			return false;
		return true;
	}
}
