package com.tandbergtv.cms.portal.content.titlelist.client.model;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * AssetList's Field representation for the UI layer.
 * 
 * @author dpsilva
 * 
 */
public class UiMetadataField implements IsSerializable {

	private long id;
	private String name;
	private String value;
	private String displayName;
	private UiDataType dataType;
	private boolean required;
	private List<Option> options;

	/**
	 * Default constructor
	 */
	public UiMetadataField() {
		super();
	}

	/**
	 * Constructor
	 * 
	 * @param name
	 *            the name
	 * @param displayName
	 *            the display name
	 * @param dataType
	 *            the data type
	 */
	public UiMetadataField( String name, String displayName, UiDataType dataType ) {
		super();
		this.name = name;
		this.displayName = displayName;
		this.dataType = dataType;
	}

	/**
	 * Get the id
	 * 
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * Set the id
	 * 
	 * @param id
	 *            the id to set
	 */
	public void setId( long id ) {
		this.id = id;
	}

	/**
	 * Get the value
	 * 
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Set the value
	 * 
	 * @param value
	 *            the value to set
	 */
	public void setValue( String value ) {
		this.value = value;
	}

	/**
	 * Get the name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the name
	 * 
	 * @param name
	 *            the name to set
	 */
	public void setName( String name ) {
		this.name = name;
	}

	/**
	 * Get the display name
	 * 
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Set the display name
	 * 
	 * @param displayName
	 *            the displayName to set
	 */
	public void setDisplayName( String displayName ) {
		this.displayName = displayName;
	}

	/**
	 * Get the data type
	 * 
	 * @return the data type
	 */
	public UiDataType getDataType() {
		return dataType;
	}

	/**
	 * Set the data type
	 * 
	 * @param dataType
	 *            the data type to set
	 */
	public void setDataType( UiDataType dataType ) {
		this.dataType = dataType;
	}
	
	/**
	 * Get if the field is required or not
	 * 
	 * @return the required value
	 */
	public boolean isRequired() {
		return this.required;		
	}

	/**
	 * Set if the field is required or not
	 * 
	 * @param required
	 *            the required value
	 */
	public void setRequired( boolean required ) {
		this.required = required;		
	}

	public List<Option> getOptions() {
		return options;
	}

	public void setOptions( List<Option> options ) {
		this.options = options;
	}

	static public class Option implements IsSerializable {

		String name;
		String value;

		public Option() {}
		public Option( String name, String value ) {
			this.name = name;
			this.value = value;
		}
		public String getName() {
			return name;
		}
		public String getValue() {
			return value;
		}
		
	}
}
