package com.tandbergtv.cms.portal.content.titlelist.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKey;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;

/**
 * AssetList's representation for the UI layer.
 * 
 * @author dpsilva
 */
public class UiTitleList implements IsSerializable {

	private UiTitleListKey key;
	private String name;
	private List<UiAssetMap> assets;
	private int totalCount;
	private Long contentClass;
	private String description;
	private String type;
	private List<UiColumn> titleListColumns;
	private List<UiColumn> titleColumns;
	private List<UiColumn> assetColumns;
	private List<UiMetadataField> metadataFields;
	private boolean hasViewPermission = true;

	/**
	 * Default constructor
	 */
	public UiTitleList() {
		this.key = new UiTitleListKey( 0 );
		this.assets = new ArrayList<UiAssetMap>();
		this.metadataFields = new ArrayList<UiMetadataField>();
	}

	/**
	 * Constructor
	 * 
	 * @param totalCount
	 *            the total count of assets of this title list present in
	 *            database
	 * @param assets
	 *            the list of assets, not necessarily all assets present in
	 *            database if pagination is being used
	 */
	public UiTitleList( int totalCount, List<UiAssetMap> assets ) {
		this();
		this.totalCount = totalCount;
		this.assets = assets;
		if ( this.assets == null ) {
			this.assets = new ArrayList<UiAssetMap>();
		}
	}

	/**
	 * Constructor
	 * 
	 * @param id
	 *            the id
	 * @param name
	 *            the name
	 * @param description
	 *            the description
	 */
	public UiTitleList( long id, String name, String description ) {
		this();
		this.key = new UiTitleListKey( id );
		this.name = name;
		this.description = description;
	}

	/**
	 * Add an ui asset map to this title if it is not already added
	 * 
	 * @param uiAssetMap
	 *            the ui asset map
	 */
	public void addAsset( UiAssetMap uiAssetMap ) {
		if ( !present( uiAssetMap ) ) {
			this.assets.add( uiAssetMap );
		}
	}

	private boolean present( UiAssetMap asset ) {
		for ( UiAssetMap t : this.assets ) {
			if ( t.getAsset().getId() == asset.getAsset().getId() ) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Move the ui asset map in the list from one position to another
	 * 
	 * @param currentIndex
	 *            the current position
	 * @param newIndex
	 *            the ne position
	 */
	public void move( int currentIndex, int newIndex ) {
		UiAssetMap asset = assets.remove( currentIndex );
		assets.add( newIndex, asset );
	}

	/**
	 * Get the assets
	 * 
	 * @return the assets
	 */
	public List<UiAssetMap> getAssets() {
		return assets;
	}

	/**
	 * Set the assets
	 * 
	 * @param assets
	 *            the assets to set
	 */
	public void setAssets( List<UiAssetMap> assets ) {
		this.assets = assets;
	}

	/**
	 * Get the total count of assets of this title list present in database
	 * 
	 * @return the total count of assets
	 */
	public int getTotalCount() {
		return totalCount;
	}

	/**
	 * Set the total count of assets of this title list present in database
	 * 
	 * @param totalCount
	 *            the total count of assets
	 */
	public void setTotalCount( int totalCount ) {
		this.totalCount = totalCount;
	}

	/**
	 * Get the title list name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the title list name
	 * 
	 * @param name
	 *            the name
	 */
	public void setName( String name ) {
		this.name = name;
	}

	/**
	 * Get the key
	 * 
	 * @return the key
	 */
	public UiTitleListKey getKey() {
		return key;
	}

	/**
	 * Set the key
	 * 
	 * @param key
	 *            the key to set
	 */
	public void setKey( UiTitleListKey key ) {
		this.key = key;
	}

	/**
	 * Get the description
	 * 
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Set the description
	 * 
	 * @param description
	 *            the description
	 */
	public void setDescription( String description ) {
		this.description = description;
	}

	/**
	 * Set the content class
	 * 
	 * @param contentClass
	 *            the content class
	 */
	public void setContentClass( Long contentClass ) {
		this.contentClass = contentClass;
	}

	/**
	 * Get the content class
	 * 
	 * @return the content class
	 */
	public Long getContentClass() {
		return contentClass;
	}

	/**
	 * Set the title list type
	 * 
	 * @param type
	 *            the title list type
	 */
	public void setType( String type ) {
		this.type = type;
	}

	/**
	 * Get the title list type
	 * 
	 * @return the title list type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Set the title list columns
	 * 
	 * @param titleListColumns
	 *            the title list columns
	 */
	public void setTitleListColumns( List<UiColumn> titleListColumns ) {
		this.titleListColumns = titleListColumns;
	}

	/**
	 * Get the title list columns
	 * 
	 * @return the title list columns
	 */
	public List<UiColumn> getTitleListColumns() {
		return titleListColumns;
	}

	/**
	 * Set the title columns
	 * 
	 * @param titleColumns
	 *            the title columns
	 */
	public void setTitleColumns( List<UiColumn> titleColumns ) {
		this.titleColumns = titleColumns;
	}

	/**
	 * Get the title columns
	 * 
	 * @return the title columns
	 */
	public List<UiColumn> getTitleColumns() {
		return titleColumns;
	}

	/**
	 * Set the asset columns
	 * 
	 * @param assetColumns
	 *            the asset columns
	 */
	public void setAssetColumns( List<UiColumn> assetColumns ) {
		this.assetColumns = assetColumns;
	}

	/**
	 * Get the asset columns
	 * 
	 * @return the asset columns
	 */
	public List<UiColumn> getAssetColumns() {
		return assetColumns;
	}

	/**
	 * Set the metadata fields
	 * 
	 * @param metadataFields
	 *            the metadata fields
	 */
	public void setMetadataFields( List<UiMetadataField> metadataFields ) {
		this.metadataFields = metadataFields;
	}

	/**
	 * Get the metadata fields
	 * 
	 * @return the metadata fields
	 */
	public List<UiMetadataField> getMetadataFields() {
		return metadataFields;
	}

	public void setHasViewPermission( boolean hasViewPermission ) {
		this.hasViewPermission = hasViewPermission;
	}

	public boolean hasViewPermission() {
		return hasViewPermission;
	}

}
