package com.tandbergtv.cms.portal.content.titlelist.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Collection of titlelists with the total count
 * 
 * @author dpsilva
 * 
 */
public class UiTitleLists implements IsSerializable {

	private List<UiTitleList> lists;
	private int totalCount;

	/**
	 * Default constructor
	 */
	public UiTitleLists() { }
	
	/**
	 * Constructor
	 * 
	 * @param lists
	 *            the list of title lists, not necessarily all title lists
	 *            present in database if pagination is being used
	 * @param totalCount
	 *            the total count of title lists present in database
	 */
	public UiTitleLists( List<UiTitleList> lists, int totalCount ) {
		super();
		this.lists = lists;
		if ( this.lists == null ) {
			this.lists = new ArrayList<UiTitleList>();
		}
		this.totalCount = totalCount;
	}

	/**
	 * Get the list of title lists
	 * 
	 * @return the lists
	 */
	public List<UiTitleList> getLists() {
		return lists;
	}

	/**
	 * Set the total count of title lists present in database
	 * 
	 * @return the total count
	 */
	public int getTotalCount() {
		return totalCount;
	}
}
