package com.tandbergtv.cms.portal.content.titlelist.client.rpc;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleLists;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListExportResponse;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * RPC service which helps with all titlelist operations.
 * 
 * @author spuranik
 * 
 */
@RemoteServiceRelativePath("service/content/titlelistService")
public interface ITitleListService extends RemoteService {

	/**
	 * Gets the assetlist corresponding to this assetlist id.
	 * 
	 * @param id
	 * @return
	 */
    UiTitleList get(long id) throws NeptuneException;

	/**
	 * Gets all the existing asset lists in the system and returns corresponding
	 * ui objects for each one of them.
	 * 
	 * @return
	 */
    UiTitleLists getTitlelists(int start, int length, String sortProperty,
			boolean isAscending) throws NeptuneException;
	


    /**
	 * Adds given assets to the title list.
	 * 
     * @param titleListId the title list id
     * @param titleAssetIdsMap the map of title ids and asset ids
     * 
     * @throws NeptuneException
     */
    void addAssetsToTitleList(long titleListId, Map<Long,List<Long>> titleAssetIdsMap) throws NeptuneException;

	/**
	 * Removes the given assets from the titlelist with the given id.
	 * 
	 * @param titleListId
	 * @param elementIds
	 */
	void removeAssetsFromTitleList(long titleListId, List<Long> elementIds) throws NeptuneException;

	/**
	 * Creates/updates a title list in the system with the given ui info
	 * 
	 * @param titleList
	 */
	UiTitleList save(UiTitleList titleList) throws NeptuneException;

	/**
	 * Deletes the title lists represented by given ids.
	 * 
	 * @param titleList
	 */
	void delete(List<Long> ids) throws NeptuneException;

	/**
	 * Xports every titlelist given in the list of ids
	 * 	and returns an object which indicates which ones were successful
	 * 	and which were not along with the error.
	 * 
	 * @param ids
	 * @return
	 * @throws NeptuneException
	 */
	TitleListExportResponse export(List<Long> ids) throws NeptuneException;
	
	/**
	 * Returns a list of template names that expect a titlelist id.
	 * 
	 * @return
	 * @throws NeptuneException
	 */
	List<String> getTemplates() throws NeptuneException;
	
	/**
	 * Sends a work order request for every select titlelist id.  
	 * 
	 * @param ids
	 * @param templateName
	 * @throws NeptuneException
	 */
	WorkOrderCreateResponse sendWorkOrderCreateMessage(List<Long> ids, String templateName) 
		throws NeptuneException;

	/**
	 * Get a map with errors from http session
	 * 
	 * @param assetListId the asset list id
	 * @return the map with errors
	 * @throws NeptuneException
	 */
	Map<String, Integer> getErrorsFromHttpSession( long assetListId ) throws NeptuneException;
}
