/**
 * 
 */
package com.tandbergtv.cms.portal.content.titlelist.client.rpc;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleLists;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListExportResponse;

/**
 * RPC service which helps with all titlelist operations.
 * 
 * @author spuranik
 * @generated generated asynchronous callback interface to be used on the client side
 * 
 */

public interface ITitleListServiceAsync {

	/**
	 * Gets the titlelist corresponding to this titlelist id.
	 * 
	 * @param id
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void get(long id, AsyncCallback<UiTitleList> callback);

	/**
	 * Gets all the existing title lists in the system and returns corresponding
	 * ui objects for each one of them.
	 * 
	 * @return
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitlelists(int start, int length, String sortProperty,
			boolean isAscending, AsyncCallback<UiTitleLists> callback);

	/**
	 * Adds given assets to the this title list.
	 * 
	 * @param titleListId
	 * @param titleAssetIdsMap
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void addAssetsToTitleList(long titleListId, Map<Long,List<Long>> titleAssetIdsMap,
			AsyncCallback<Void> callback);

	/**
	 * Removes the given titles from the titlelist with the given id.
	 * 
	 * @param titleListId
	 * @param elementIds
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void removeAssetsFromTitleList(long titleListId, List<Long> elementIds,
			AsyncCallback<Void> callback);

	/**
	 * Creates/updates a title list in the system with the given ui info
	 * 
	 * @param titleList
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void save(UiTitleList titleList, AsyncCallback<UiTitleList> callback);

	/**
	 * Deletes the title lists represented by given ids.
	 * 
	 * @param titleList
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void delete(List<Long> ids, AsyncCallback<Void> callback);

	/**
	 * Xports every titlelist given in the list of ids
	 * 	and returns an object which indicates which ones were successful
	 * 	and which were not along with the error.
	 * 
	 * @param ids
	 * @param  callback the callback that will be called to receive the return value
	 * @return
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void export(List<Long> ids, AsyncCallback<TitleListExportResponse> callback);

	/**
	 * Returns a list of template names that expect a titlelist id.
	 * 
	 * @return
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTemplates(AsyncCallback<List<String>> callback);

	/**
	 * Sends a work order request for every select titlelist id.  
	 * 
	 * @param ids
	 * @param templateName
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void sendWorkOrderCreateMessage(List<Long> ids, String templateName,
			AsyncCallback<WorkOrderCreateResponse> callback);
	
	/**
	 * Get a map with errors from http session
	 * 
	 * @param assetListId the asset list id
	 * @param callback the callback that will be called to receive the return value
	 * @throws NeptuneException
	 */
	void getErrorsFromHttpSession( long assetListId, AsyncCallback<Map<String, Integer>> callback );

}
