package com.tandbergtv.cms.portal.content.titlelist.client.rpc;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetListType;

/**
 * RPC service which helps with all titlelist type operations.
 * 
 * @author dpsilva
 * 
 */
public interface ITitleListTypeServiceAsync extends RemoteService {

	/**
	 * Returns the list of titlelist types without metadata
	 * 
	 * @param callback the callback to return the results
	 */
	void getTypesWithoutMetadata( AsyncCallback<List<UiAssetListType>> callback );
	
	/**
	 * Returns the titlelist type for the given name with all metadata
	 * @param name the type name
	 * @param callback the callback to return the result
	 */
	void getTypeByName( String name, AsyncCallback<UiAssetListType> callback );

}
