package com.tandbergtv.cms.portal.content.titlelist.client.rpc;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Exception thrown if the title list info is not valid when persisting it.
 * 
 * @author spuranik
 *
 */
public class UiValidationException extends NeptuneException {

	private static final long serialVersionUID = 1L;
	private List<String> errorCodes;

	public UiValidationException() {
		errorCodes = new ArrayList<String>();
	}
	
	public UiValidationException(List<String> codes) {
		errorCodes = new ArrayList<String>();
		for(String c : codes) {
			errorCodes.add(c);
		}
	}

	/**
	 * @return the errorCodes
	 */
	public List<String> getErrorCodes() {
		return errorCodes;
	}
}
