package com.tandbergtv.cms.portal.content.titlelist.client.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleAssetActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

public class AddAssetToTitleList implements ITitleAssetActionService {

	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);

	private ITitleListServiceAsync titleListService = (ITitleListServiceAsync) GWT.create(ITitleListService.class);
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}

	@Override
	public void execute(final List<Long> assetIds, String serviceParameter, IActionInput input,
			final AsyncCallback<IOperationResult> callback) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void executeAddAssets(Map<Long, List<Long>> titleAssetIdsMap, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		final TitleActionInput actionInput = (TitleActionInput) input;
		if ( actionInput.getTitleListId() == 0 ) {
			callback.onFailure(new RuntimeException(displayConstants.titleListRequiredFailure()));
			return;
		}
		final BusyIndicator busyIndicator =  new BusyIndicator();
		busyIndicator.center();
		titleListService.addAssetsToTitleList(actionInput.getTitleListId(), titleAssetIdsMap, new NeptuneAsyncCallback<Void>(){
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				if ( caught instanceof UiValidationException ) {
					List<String> errorCodes = ((UiValidationException) caught).getErrorCodes();
    				StringBuilder sb = new StringBuilder( displayConstants.invalidAssets() );
    				for (String code : errorCodes) {
    					if (sb.length() > 0) {
    						sb.append("\n");
    					}
    					sb.append(" - ");
    					try{
    						sb.append(displayConstants.getString(code));
    					}
    					catch(MissingResourceException ex){
    						sb.append(code); //hack - code is indeed the error message
    					}
    				}
    				Window.alert( sb.toString() );
				} else {
					Window.alert(caught.getLocalizedMessage());
				}
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				busyIndicator.hide();
				callback.onSuccess(new AddAssetToTitleListResult(actionInput.getSpec(), actionInput.getTitleListId()));
			}} );
	}

	@Override
	public String getDescription() {
		return displayConstants.addAssetToList();
	}

	@Override
	public String getName() {
		return displayConstants.addAssetToListServiceName();
	}

	@Override
	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		History.newItem("Content.TitleLists.View?titleListId="
				+ ((AddAssetToTitleListResult) result).getTitleListId() + "&spec="
				+ ((AddAssetToTitleListResult) result).getSpec());
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		return inputData.getTitleListId() == 0 ? false : true;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
