package com.tandbergtv.cms.portal.content.titlelist.client.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Ui service that invokes the backend to queue workorder requests for titlelists.
 * 
 * @author spuranik
 * 
 */
public class RunTemplate implements ITitleListService {

	private TitleListConstants displayConstants = (TitleListConstants) GWT.create(TitleListConstants.class);
	private String NEWLINE_CHAR = "\n";
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}
	
	@Override
	public void execute(List<Long> ids, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		// ensure that a template has been selected
		if (serviceParameter == null || serviceParameter.isEmpty()) {
			callback.onFailure(new RuntimeException(
					displayConstants.titleListRunTemplateTemplateSelectionError()));
			return;
		}
		ITitleListServiceAsync service = GWT
				.create(com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService.class);
		service.sendWorkOrderCreateMessage(ids, serviceParameter,
				new NeptuneAsyncCallback<WorkOrderCreateResponse>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						callback.onFailure(caught);
					}

					@Override
					public void onNeptuneSuccess(WorkOrderCreateResponse result) {
						callback.onSuccess(prepareResult(result));
					}
				});
	}

	@Override
	public String getDescription() {
		return displayConstants.titleListRunTemplateServiceDescription();
	}

	@Override
	public String getName() {
		return displayConstants.titleListRunTemplateServiceName();
	}

	@Override
	public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
		ITitleListServiceAsync service = GWT
				.create(com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService.class);
		service.getTemplates(new NeptuneAsyncCallback<List<String>>() {
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(List<String> result) {
				callback.onSuccess(result);
			}
		});
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}

	/**
	 * Prepares a message indicating titlelists for which work orders were
	 * scheduled and those which were not.
	 * 
	 * @param response
	 * @return
	 */
	private IOperationResult prepareResult(WorkOrderCreateResponse response) {
		StringBuilder sb = new StringBuilder();
		
		// sucessfully queued work orders
		if(response.getQueuedWorkOrders().size() > 0) {
			sb.append(displayConstants.titleListRunTemplateSuccessPrefix());
			StringBuilder ids = new StringBuilder();
			for (long id : response.getQueuedWorkOrders()) {
				if (ids.length() > 0) {
					ids.append(", ");
				}
				ids.append(id);
			}
			sb.append(ids.toString());
		}
		
		// failed to queue work orders for these ids
		if(response.getFailedIds().size() > 0) {
			sb.append(NEWLINE_CHAR);
			sb.append(displayConstants.titleListRunTemplateFailurePrefix());
			StringBuilder failedIds = new StringBuilder();
			Iterator<Entry<Long, String>> iter = response.getFailedIds().entrySet().iterator();
			while (iter.hasNext()) {
				Entry<Long, String> entry = iter.next();
				if (failedIds.length() > 0) {
					failedIds.append(NEWLINE_CHAR);
				}
				failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
			}
			sb.append(failedIds.toString());
		}
		return new RunTemplateResult(sb.toString());
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		// This service is never selected either as default because there is no
		// external page connecting to this feature.
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}


}
