package com.tandbergtv.cms.portal.content.titlelist.client.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * This service is responsible to delete titles given the list of title ids.
 * 
 * @author spuranik
 * 
 */
public class TitleListDeleteService implements ITitleListService {

	private TitleListConstants displayConstants = (TitleListConstants) GWT.create(TitleListConstants.class);
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
		
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #execute(java.util.List, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	public void execute(final List<Long> ids, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		ITitleListServiceAsync service = GWT
				.create(com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService.class);
		service.delete(ids, new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				StringBuilder sb = new StringBuilder();
				for (long id : ids) {
					if (sb.length() > 0) {
						sb.append(", ");
					}
					sb.append(id);
				}
				callback.onSuccess(new TitleListDeleteResult(displayConstants
						.titleListDeleteSuccessMessage() + " " + sb.toString()));
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #getDescription()
	 */
	public String getDescription() {
		return displayConstants.titleListDeleteServiceDescription();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #getName()
	 */
	public String getName() {
		return displayConstants.titleListDeleteServiceName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #gotoResultPage
	 * (com.tandbergtv.cms.portal.ui.title.client.model.uiservice.
	 * ITitleOperationResult,
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView)
	 */
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}

	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public boolean getConfirmation() {
		return true;
	}
	
	@Override
	public boolean isSelected(ViewInput inputData) {
		// If scheduleid and titlelist id are not populated then use this as the
		// default selected item.
		return true;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}


}
