package com.tandbergtv.cms.portal.content.titlelist.client.services;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Ui exception indicating problems when working with a title list. 
 * 
 * @author spuranik
 *
 */
public class TitleListException extends NeptuneException {

	private static final long serialVersionUID = 1L;

	private String errorCode;
	
	private String message;
	
	public TitleListException() {
		
	}

	public TitleListException(String errorCode) {
		super();
		this.errorCode = errorCode;
	}

	public TitleListException(String message, String errorCode) {
		super(message);
		this.errorCode = errorCode;
	}
	
	/**
	 * @return the errorCode
	 */
	public String getErrorCode() {
		return errorCode;
	}

	/**
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
}
