package com.tandbergtv.cms.portal.content.titlelist.client.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;

/**
 * Response from server after attempting to export the requested titlelists in
 * the given spec.
 * 
 * @author spuranik
 * 
 */
public class TitleListExportResponse implements IOperationResult {

	// map of: titlelist id -> filepath where this titlist was exported. 
	private Map<Long, String> sucessfulExportTitleList;
	// map of titlelist id -> error code for failure
	private Map<Long, String> failedExportTitleList;

	private String NEWLINE_CHAR = "\n";

	public TitleListExportResponse() { 
		sucessfulExportTitleList = new HashMap<Long, String>();
		failedExportTitleList = new HashMap<Long, String>();
	}
	
	public TitleListExportResponse(Map<Long, String> sucessfulExportTitleList,
			Map<Long, String> failedExportTitleList) {
		super();
		this.sucessfulExportTitleList = sucessfulExportTitleList;
		this.failedExportTitleList = failedExportTitleList;
	}

	/**
	 * @return the sucessfulExportTitleList
	 */
	public Map<Long, String> getSucessfulExportTitleList() {
		return sucessfulExportTitleList;
	}

	/**
	 * @param sucessfulExportTitleList the sucessfulExportTitleList to set
	 */
	public void setSucessfulExportTitleList(
			Map<Long, String> sucessfulExportTitleList) {
		this.sucessfulExportTitleList = sucessfulExportTitleList;
	}

	/**
	 * @return the failedExportTitleList
	 */
	public Map<Long, String> getFailedExportTitleList() {
		return failedExportTitleList;
	}

	/**
	 * @param failedExportTitleList the failedExportTitleList to set
	 */
	public void setFailedExportTitleList(Map<Long, String> failedExportTitleList) {
		this.failedExportTitleList = failedExportTitleList;
	}

	@Override
	public String getMessage() {
		TitleListConstants displayConstants = (TitleListConstants) GWT.create(TitleListConstants.class);
		StringBuilder sb = new StringBuilder();
		boolean prefixDelimiter = false;
		
		/* gather successful ones */
		if (sucessfulExportTitleList.size() > 0) {
			sb.append(displayConstants.titleListExportSuccessPrefix() + NEWLINE_CHAR);
			Iterator<Entry<Long, String>> successIter = sucessfulExportTitleList
					.entrySet().iterator();
			while (successIter.hasNext()) {
				Entry<Long, String> entry = successIter.next();
				if (prefixDelimiter) {
					sb.append(NEWLINE_CHAR);
				}
				sb.append("TitleList " + entry.getKey() + " [" + entry.getValue() + "]");
				prefixDelimiter = true;
			}
		}
		
		/* gather failed ones with error codes */
		if (failedExportTitleList.size() > 0) {
			if (sucessfulExportTitleList.size() > 0) {
				sb.append(NEWLINE_CHAR);
			}
			sb.append(displayConstants.titleListExportFailurePrefix() + NEWLINE_CHAR);
			prefixDelimiter = false;
			Iterator<Entry<Long, String>> failedIter = this.failedExportTitleList.entrySet().iterator();
			while (failedIter.hasNext()) {
				Entry<Long, String> entry = failedIter.next();
				if (prefixDelimiter) {
					sb.append(NEWLINE_CHAR);
				}
				sb.append("TitleList " + entry.getKey() + " : " + entry.getValue());
				prefixDelimiter = true;
			}
		}
		
		return sb.toString();
	}
}
