package com.tandbergtv.cms.portal.content.titlelist.client.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Ui service that lets the user export a title list into an xml. The generated
 * file is saved in the location configured in contentMgmt.properties
 * 
 * @author spuranik
 * 
 */
public class TitleListXportService implements ITitleListService {

	private TitleListConstants displayConstants = (TitleListConstants) GWT.create(TitleListConstants.class);
	private ITitleListServiceAsync service = (ITitleListServiceAsync) GWT
			.create(com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService.class);
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}

	@Override
	public void execute(List<Long> ids, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		service.export(ids, new NeptuneAsyncCallback<TitleListExportResponse>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(TitleListExportResponse result) {
				// If there were some successfully exported lists, show the summary. 
				// Note this message may contain failure messages too.
				if(!((TitleListExportResponse)result).getSucessfulExportTitleList().isEmpty()) {
					callback.onSuccess(result);	
				} else { 
					// If there were no successful exports, all failed, the message should be shown 
					// in the error panel.
					if(!((TitleListExportResponse)result).getFailedExportTitleList().isEmpty()) {
						callback.onFailure(new RuntimeException(result.getMessage()));
					}	
				}
			}});
	}

	@Override
	public String getDescription() {
		return displayConstants.titleListXportServiceDescription();
	}

	@Override
	public String getName() {
		return displayConstants.titleListXportServiceName();
	}

	@Override
	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		// This service is never selected either as default because there is no
		// external page connecting to this feature.
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return false;
	}

}
