package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.imageeditor.TypedImageBoxWidget;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetMap;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiDataType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.WidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;

public class AssetMetadataForm extends Composite {

	private VerticalContainer verticalContainer;

	private FormContainer form;

	// button widgets
	private List<ButtonWidget> buttonsList;

	private Long assetListId;
	
	// the ui asset map
	private UiAssetMap uiAssetMap;

	// the title metadata fields
	private Map<UiMetadataField, DataTypeWidget<?>> metadataFieldsMap;
	
	private TitleListConstants constants = (TitleListConstants) GWT.create( TitleListConstants.class );

	public AssetMetadataForm() {
		this( null, null, null );
	}

	public AssetMetadataForm( Long assetListId, UiAssetMap uiAssetMap, List<UiMetadataField> metadataFields ) {
		this.assetListId = assetListId;
		this.uiAssetMap = uiAssetMap;
		this.metadataFieldsMap = new HashMap<UiMetadataField, DataTypeWidget<?>>();
		init( metadataFields );
	}

	/**
	 * Inits input and widgets used by this form.
	 */
	private void init( List<UiMetadataField> metadataFields ) {
		this.verticalContainer = new VerticalContainer();
		this.buttonsList = new ArrayList<ButtonWidget>();

		form = new FormContainer( HasHorizontalAlignment.ALIGN_LEFT );
		
		DefaultDataTypeWidgetFactory factory = new DefaultDataTypeWidgetFactory();
		
		for ( UiMetadataField metadataField : metadataFields ) {
			UiMetadataField metadataFieldCopy = new UiMetadataField();
			copyProperties( metadataField, metadataFieldCopy );
			DataTypeWidget<?> dataTypeWidget = createDataTypeWidget( factory,
					metadataFieldCopy );

			if ( dataTypeWidget != null ) {
				metadataFieldsMap.put( metadataFieldCopy, dataTypeWidget );
				form.addRow( metadataFieldCopy.getDisplayName(), dataTypeWidget, metadataFieldCopy.isRequired() );
			}
		}
		
		verticalContainer.add( form );
		verticalContainer.setWidth( "100%" );

		this.initWidget( verticalContainer );
	}

	// TODO this does not belong in here it should be in the UIMetadataField class
	private void copyProperties( UiMetadataField source, UiMetadataField dest ) {
		dest.setDataType( source.getDataType() );
		dest.setDisplayName( source.getDisplayName() );
		dest.setId( source.getId() );
		dest.setName( source.getName() );
		dest.setValue( source.getValue() );
		dest.setRequired( source.isRequired() );
		dest.setOptions( source.getOptions() );
	}

	private DataTypeWidget<?> createDataTypeWidget( DefaultDataTypeWidgetFactory factory,
			UiMetadataField metadataField ) {

		DataTypeWidget<?> dataTypeWidget = null;

		if ( UiDataType.STRING.equals( metadataField.getDataType() ) ) {
			StringWidgetConfiguration swc = new StringWidgetConfiguration();
			List<UiMetadataField.Option> optionsList = metadataField.getOptions();
			if( optionsList != null && !optionsList.isEmpty() ) {
				List<UIValueOption> options = new ArrayList<UIValueOption>();
				for( UiMetadataField.Option option : optionsList ) {
					UIValueOption uiso = new UIValueOption( option.getName(), option.getValue() );
					options.add( uiso );
				}
				swc.setAnyValueAllowed( false );
				swc.setOptions( options );
			}
			dataTypeWidget = factory.createStringWidget( swc );

		} else if ( UiDataType.INTEGER.equals( metadataField.getDataType() ) ) {
			dataTypeWidget = factory.createIntegerWidget( new WidgetConfiguration() );

		} else if ( UiDataType.IMAGE.equals( metadataField.getDataType() ) ) {
			dataTypeWidget = createImageWidget( metadataField.getName() );
		} 
		
		return dataTypeWidget;
	}

	public FormContainer getForm() {
		return form;
	}

	public void addButton( ButtonWidget button ) {
		this.buttonsList.add( button );
	}

	public void removeButton( ButtonWidget button ) {
		this.buttonsList.remove( button );
	}

	private void updateMetadataFields() {
		Set<Entry<UiMetadataField, DataTypeWidget<?>>> metadataEntries = metadataFieldsMap.entrySet();
		for ( Entry<UiMetadataField, DataTypeWidget<?>> entry : metadataEntries ) {
			entry.getKey().setValue( entry.getValue().getTextValue() );
		}
	}

	public void setBorderWidth( int width ) {
		verticalContainer.setBorderWidth( width );
	}

	public List<UiMetadataField> getMetadataFields() {
		updateMetadataFields();
		return new ArrayList<UiMetadataField>( metadataFieldsMap.keySet() );
	}

	public void initMetadataFields( List<UiMetadataField> assetMetadataFields ) {
		for ( UiMetadataField uiMetadataField : assetMetadataFields ) {
			for ( Entry<UiMetadataField, DataTypeWidget<?>> entry : metadataFieldsMap.entrySet() ) {
				if ( uiMetadataField.getName().equals( entry.getKey().getName() ) ) {
					String value = uiMetadataField.getValue();
					entry.getValue().setTextValue( value );
					break;
				}
			}
		}
	}
	
	private TypedImageBoxWidget<String> createImageWidget(String metadataFieldName) {
		IValueConverter<String> converter = new StringConverter();
		
		SaveImageRequest saveImageRequest = new SaveImageRequest();
		if ( uiAssetMap != null ) {			
			saveImageRequest.setAssetListId( assetListId );
			saveImageRequest.setAssetListElementId( uiAssetMap.getId() );
			saveImageRequest.setMetadataFieldName( metadataFieldName );
		}

		TypedImageBoxWidget<String> widget = new TypedImageBoxWidget<String>( converter, saveImageRequest );
		
		return widget;
	}
	
	public boolean isValid() {
		return getInvalidFieldsMessages().size() == 0;
	}
	
	public List<String> getInvalidFieldsMessages() {
		List<String> invalidFields = new ArrayList<String>();

		Set<Entry<UiMetadataField, DataTypeWidget<?>>> entries = metadataFieldsMap.entrySet();
		for ( Entry<UiMetadataField, DataTypeWidget<?>> entry : entries ) {
			UiMetadataField field = entry.getKey();
			DataTypeWidget<?> widget = entry.getValue();
			
			if ( field.isRequired() ) {
				if ( ( widget.getTextValue() == null ) 
						|| ( widget.getTextValue().trim().equals( "" ) ) ) {
					invalidFields.add( field.getDisplayName() + " (" + constants.requiredFieldToolTip() + ")" );
					widget.showValidationError( constants.requiredFieldToolTip() );
				}
			} 
			if ( !widget.isValidValue() ) {
				invalidFields.add( field.getDisplayName() + " (" + widget.getErrorToolTip() + ")" );
			}
		}
		
		return invalidFields;
	}

	public UiAssetMap getUiAssetMap() {
		return uiAssetMap;
	}

}
