package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Panel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.ExpandingFeatureImages;

/**
 * The button to represent the expand/collapse action
 * 
 * @author Daniel Silva
 */
public class ExpandCollapseButton extends ImageWidget {
	
	private Panel expandedPanel;
	
	private final ExpandingFeatureImages bundle;
	
	private ImageResource expandImage;
	
	private ImageResource collapseImage;	
	
	/**
	 * Constructor
	 * 
	 * @param expandedPanel The expanded panel
	 */
	public ExpandCollapseButton( Panel expandedPanel ) {
		this( expandedPanel, null, null );
	}
	
	/**
	 * Constructor
	 * 
	 * @param expandedPanel The expanded panel
	 * @param expandImage The expand image
	 * @param collapseImage The collapse image
	 */
	public ExpandCollapseButton( Panel expandedPanel, ImageResource expandImage, ImageResource collapseImage ) {
		this.expandedPanel = expandedPanel;
		bundle = GWT.create(ExpandingFeatureImages.class);
		if ( expandImage != null ) {
			this.expandImage = expandImage;
		} else {
			this.expandImage = bundle.expand();
		}
		if ( collapseImage != null ) {
			this.collapseImage = collapseImage;
		} else {
			this.collapseImage = bundle.collapse();
		}
		this.setResource( this.expandImage );
		this.setStyleName( TableConstants.STYLE_HEADER_SORTABLE_COL_TEXT );
	}

	/**
	 * Set the expanded panel
	 * 
	 * @param expandedPanel
	 */
	public void setExpandedPanel(Panel expandedPanel) {
		this.expandedPanel = expandedPanel;
	}

	/**
	 * Get the expanded panel
	 * 
	 * @return The expanded panel
	 */
	public Panel getExpandedPanel() {
		return expandedPanel;
	}
	
	/**
	 * Set the expand image
	 * 
	 * @param expandImage The expand image
	 */
	public void setExpandImage( ImageResource expandImage ) {
		this.expandImage = expandImage;
	}
	
	/**
	 * Set the collapse image
	 * 
	 * @param collapseImage The collapse image
	 */
	public void setCollapseImage( ImageResource collapseImage ) {
		this.collapseImage = collapseImage;
	}
	
	/**
	 * Changes the button state between expanded and collaped
	 */
	public void changeState() {
		if ( expandedPanel != null ) {
			expandedPanel.setVisible( !expandedPanel.isVisible() );
			if ( expandedPanel.isVisible() ) {				
				this.setResource( collapseImage );
			} else {
				this.setResource( expandImage );
			}			
		}		
	}	
	
	public boolean isExpanded() {
		return expandedPanel.isVisible();
	}
}
