package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class TitleListAnchorChangeListener implements AnchorChangeListener {

	// constants in the url e.g. ?titleListId=1
	private static String TITLE_LIST_ID = "titleListId";
	private static String PARAMETER_DELIMITER = "&";
	private static String VALUE_DELIMITER = "=";
	private final TitleListsPanel widget;

	public TitleListAnchorChangeListener(TitleListsPanel titleListsPanel) {
		this.widget = titleListsPanel;
	}

	@Override
	public void anchorChanged(String anchor) {
		long titleListId = 0L;

		/* Ensure that the widget state is cleaned up */
		widget.cleanup();
		if (anchor != null && anchor.equalsIgnoreCase("Create")) {
			widget.create();

		}
		/* Check for anchor with title list id */
		else if (anchor != null && anchor.contains(TITLE_LIST_ID)) {
			widget.getTitleListsTable().reset();

			// skip the first char
			anchor = anchor.substring(1);
			// extract the info from the url
			String[] params = anchor.split(PARAMETER_DELIMITER);
			for (String p : params) {
				String[] paramValue = p.split(VALUE_DELIMITER);
				if (paramValue[0].equalsIgnoreCase(TITLE_LIST_ID)) {
					titleListId = Long.parseLong(paramValue[1]);
				}
			}

			// get the titleList from the server.
			// extra effort to get titleListId
			if (titleListId == 0) {
				String[] idParams = anchor.split("titleListId=");

				String[] params2 = idParams[1].split(PARAMETER_DELIMITER);
				if (params2[0] != null) {
					titleListId = Long.parseLong(params2[0]);
				}

			}

			ITitleListServiceAsync titleListService = GWT.create(ITitleListService.class);
			titleListService.get(titleListId, new NeptuneAsyncCallback<UiTitleList>() {
				public void onNeptuneFailure(Throwable caught) {
					Window.alert(caught.getLocalizedMessage());
				}

				public void onNeptuneSuccess(UiTitleList result) {
					
					widget.getTitleListsTable().showDetailView(new UiTitleListRecord(result));
					
					widget.setTabSize();
					widget.getMessageArea().reset();
					widget.getMessageArea().setInfoMessage("Title List has been saved");
					
				}
			});
		} else {
			widget.refresh(null);
			widget.getTitleListsTable().setAnchor(anchor);
		}
	}
}
