package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import java.util.Iterator;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Panel which is displayed when the user wants to create a title list.
 * 
 * @author spuranik
 * 
 */
public class TitleListCreatePanel extends VerticalContainer {

	// widgets used in this view
	private HeaderPanel headerPanel;
	
	private TitleListForm titleListForm;
	
	// error
	private MessageArea messageArea;
	private TitleListConstants constants = (TitleListConstants) GWT.create(TitleListConstants.class);
	private ContentConstants contentConstants = (ContentConstants) GWT
			.create(ContentConstants.class);
	private ITitleListServiceAsync service = (ITitleListServiceAsync) GWT.create(ITitleListService.class);
	private ResizableContainer resizableContainer;
	public TitleListCreatePanel(final String spec) {
		headerPanel = new HeaderPanel(constants.createTitleListHeader());
		titleListForm = new TitleListForm();
		this.setWidth("100%");
		// error panel
		messageArea = new MessageArea();
		messageArea.reset();
		// save button
		ButtonWidget saveButton = new ButtonWidget(constants.saveTitleListButtonName());
		saveButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
        saveButton.addStyleName(StyleNames.STYLE_EB_BTN);
        saveButton.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
        saveButton.addStyleName(StyleNames.STYLE_SAVE_BUTTON_ICON);	
		saveButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				if ( titleListForm.isValid() ) {
					service.save(titleListForm.getCurrentUiTitleList(), 
						new NeptuneAsyncCallback<UiTitleList>() {

							@Override
							public void onNeptuneFailure(Throwable caught) {
								if(caught instanceof UiValidationException) {
									messageArea.setErrorHTML(getErrorMessageFromList( ( (UiValidationException) caught ).getErrorCodes() ));
									resizableContainer.updateSize();
								}
							}

							@Override
							public void onNeptuneSuccess(UiTitleList result) {
								//messageArea.reset();
								//messageArea.setInfoMessage("Title List has been saved");
								History.newItem("Content.TitleLists.View?titleListId="
						                + result.getKey().getId() + "&spec=" + spec);
							}
						}
					);
				} else {
					StringBuffer sbInvalidMessage = new StringBuffer( constants.invalidFormData() );
					for ( String invalidFieldMessage : titleListForm.getInvalidFieldsMessages() ) {
						sbInvalidMessage.append( "<br>" );
						sbInvalidMessage.append( " - " );
						sbInvalidMessage.append( invalidFieldMessage );
					}
					messageArea.setErrorHTML(sbInvalidMessage.toString() );
					resizableContainer.updateSize();
				}
				
			}
		});
	
		
		// cancel button
		ButtonWidget cancelButton = new ButtonWidget(constants.cancelTitleListButtonName());
		cancelButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
        cancelButton.addStyleName(StyleNames.STYLE_EB_BTN);
		cancelButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				History.newItem("Content.TitleLists.View?spec=" + spec);
			}
		});
	
		resizableContainer = new ResizableContainer(titleListForm, "Title List", null);
		resizableContainer.addHeightOffsettingWidget(headerPanel);
		resizableContainer.addHeightOffsettingWidget(messageArea);
		resizableContainer.addBottomWidget("Title List", saveButton);
		resizableContainer.addBottomWidget("Title List", cancelButton);
		
		add(headerPanel);
		add(messageArea);
		add(resizableContainer);
	}
	private String getErrorMessageFromList(List<String> errorCodes) {
		String message = "";
		if(errorCodes != null) {
			for(Iterator<String> i = errorCodes.iterator(); i.hasNext();) {
				String code = i.next();
				message += contentConstants.getString(code);
				if (i.hasNext()) {
					message += "<br>"; 
				}
			}
		}
		return message;
	}

}
