package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.titlelist.client.Permissions;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a given titlelist.
 * 
 * @author spuranik
 * 
 */
public class TitleListDetailFeature extends 
		AbstractDetailFeature<UiTitleListKey, UiTitleListRecord> {

	private String spec;
	private NeptuneSecurity security;
	private TitleListsPanel parentPanel;
	
	private ITitleListServiceAsync titleListService = GWT.create(ITitleListService.class);
	
	private TitleListConstants constants = (TitleListConstants) GWT.create(TitleListConstants.class);

	public TitleListDetailFeature(String spec, NeptuneSecurity security, TitleListsPanel parentPanel) {
		super(new UiTitleListKeySerializer());
		this.spec = spec;
		this.security = security;
		this.parentPanel = parentPanel;
	}

	@Override
	public void delete(List<UiTitleListRecord> records, AsyncCallback<Void> callback) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void getNew(AsyncCallback<UiTitleListRecord> callback) {
		throw new UnsupportedOperationException();
	}

	@Override
	public DetailView<UiTitleListKey, UiTitleListRecord> getView(
			UiTitleListRecord record,
			DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback) {
		parentPanel.cleanup();

		TitleListDetailView view = new TitleListDetailView(this.spec, this.security, record, callback, parentPanel);
		return view;
	}

	/*
	 * The detail link is shown only if the user has asset view permissions and
	 * the column is the name column.
	 */
	@Override
	public boolean hasDetailLink(Column<?, UiTitleListRecord> column) {
		return column.getDisplayName().equals(constants.titleListNameColumn())
				&& security.isUserInRole(Permissions.TITLELIST_VIEW);
	}

	@Override
	public void save(UiTitleListRecord record, final AsyncCallback<Void> callback) {
		titleListService.save(record.getTitleList(), new NeptuneAsyncCallback<UiTitleList>(){
			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UiTitleList result) {
				callback.onSuccess(null);
				parentPanel.getMessageArea().reset();
				parentPanel.getMessageArea().setInfoMessage("Title List has been saved");
			//	History.newItem("Content.TitleLists.View");
			}});
	}

	@Override
	public boolean showCreateButton() {
		return false;
	}

	@Override
	public boolean showDeleteButton() {
		return false;
	}
}
