package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import static com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants.STYLE_DATACELL;
import static com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants.STYLE_DATACELL_CHECKBOX;
import static com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants.STYLE_DATACELL_ICON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable.FlexCellFormatter;
import com.google.gwt.user.client.ui.HTMLTable.CellFormatter;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.titlelist.client.Permissions;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetMap;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.TitleListSearchService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.TitleListSearchServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowBeforeMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class TitleListDetailView extends Composite implements DetailView<UiTitleListKey, UiTitleListRecord> {
	private static final String DRAG_HANDLE_IMAGE_URL = "neptune_widget_toolkit/images/drag_drop_cue.gif";
	private static final String STYLE = "content-TitleListDetailView";
	private static final String STYLE_PROPERTY_PANEL = "content-TitleListDetailView-properties";
	private static final String STYLE_TABLE = "content-TitleListDetailView-titlesTable";
	private static final String INVALID_ASSETS = "invalidAssets";	


	// input
	private String spec;
	private NeptuneSecurity security;
	private UiTitleListRecord record;
	private DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback;
	private String previousName;
	private String previousDescription;
	private String previousType;
	private Long previousContentClass;
	private List<UiMetadataField> previousListMetadataFields;
	private Map<UiAssetMap, AssetMetadataForm> uiAssetMapFormMap;
	private MessageArea messageArea;
	// services
	private TitleListConstants constants = (TitleListConstants) GWT.create( TitleListConstants.class );
	private ITitleListServiceAsync service = (ITitleListServiceAsync) GWT.create( ITitleListService.class );
	private ContentConstants contentConstants = (ContentConstants) GWT.create(ContentConstants.class);
			
	private ResizableContainer resizableContainer;
	// form for title list properties
	private TitleListForm titleListForm;
	private int FORM_CONTAINER_BORDER_WIDTH = 1;
	
	// forms for title list elements properties
	private List<AssetMetadataForm> assetMetadataFormList;

	// widgets used in this view. Maincontainer has roundedContainer which in
	// turn has tableButtonsContainer.
	VerticalContainer mainContainer;
	private int SPACING_BETWEEN_MESSAGE_TABLE = 2;
	VerticalContainer propertiesButtonsContainer = new VerticalContainer();
	VerticalContainer itemsButtonsContainer = new VerticalContainer();
	TitleListsPanel parentPanel = null;
	private BusyIndicator busyIndicator;

	private static int CHECKBOX_COLUMN = 1;
	private static int DATA_ROW = 1;
	private static String ID_COLUMN_NAME = "id";

	public TitleListDetailView( String spec, NeptuneSecurity security, UiTitleListRecord record,
			DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback, TitleListsPanel parentPanel ) {
		this.parentPanel = parentPanel;
		this.messageArea = parentPanel.getMessageArea(); 
		init( spec, security, record, callback );
		initWidget( mainContainer );
		showBusyIndicator();
	}

	private void fetchMetadata( String spec, UiTitleListRecord record ) {
		TitleListSearchServiceAsync searchService = GWT.create( TitleListSearchService.class );
		searchService.getFullAssetList( record.getKey().getId(), new NeptuneAsyncCallback<UiTitleList>() {
					@Override
					public void onNeptuneFailure( Throwable caught ) {
						hideBusyIndicator();
						TitleListDetailView.this.callback.cancel( null );
					}

					@Override
					public void onNeptuneSuccess( UiTitleList uiTitleList ) {
						if ( uiTitleList.hasViewPermission() ) {
							copyProperties( uiTitleList, TitleListDetailView.this.record.getTitleList() );
							buildView( uiTitleList );
							
						} else {
							buildNoPermissionView( uiTitleList );
						}
						hideBusyIndicator();
					}

				} );
	}

	private void copyProperties( UiTitleList sourceUiTitleList, UiTitleList destUiTitleList ) {
		destUiTitleList.setKey( sourceUiTitleList.getKey() );
		destUiTitleList.setAssets( sourceUiTitleList.getAssets() );
		destUiTitleList.setAssetColumns( sourceUiTitleList.getAssetColumns() );
		destUiTitleList.setTitleColumns( sourceUiTitleList.getTitleColumns() );
		destUiTitleList.setTitleListColumns( sourceUiTitleList.getTitleListColumns() );
	}

	/**
	 * Inits input and widgets used by this view.
	 * 
	 * @param spec
	 * @param security
	 * @param record
	 * @param callback
	 */
	private void init( String spec, NeptuneSecurity security, UiTitleListRecord record,
			DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback ) {
		this.spec = spec;
		this.security = security;
		this.record = record;
		this.callback = callback;
		this.uiAssetMapFormMap = new HashMap<UiAssetMap, AssetMetadataForm>();
		this.assetMetadataFormList = new ArrayList<AssetMetadataForm>();
		this.titleListForm = new TitleListForm( record.getTitleList(),
			new NeptuneAsyncCallback<TitleListForm>() {

				@Override
				public void onNeptuneFailure( Throwable caught ) {
					Window.alert( constants.failureCreatingForm() );
				}

				@Override
				public void onNeptuneSuccess( TitleListForm result ) {
					fetchMetadata( TitleListDetailView.this.spec, TitleListDetailView.this.record );
				}
			} 
		);

		titleListForm.setBorderWidth( FORM_CONTAINER_BORDER_WIDTH );

		mainContainer = new VerticalContainer();
		mainContainer.setSpacing( SPACING_BETWEEN_MESSAGE_TABLE );
		mainContainer.setStyleName( STYLE );

		itemsButtonsContainer = new VerticalContainer();
		itemsButtonsContainer.addStyleName( TableConstants.STYLE_TABLE_PANEL );

		propertiesButtonsContainer = new VerticalContainer();
		propertiesButtonsContainer.addStyleName( TableConstants.STYLE_TABLE_PANEL );

	
		final long assetListId = record.getKey().getId();
		service.getErrorsFromHttpSession( assetListId, 
			new AsyncCallback<Map<String, Integer>>() {

    			@Override
    			public void onFailure( Throwable caught ) {
    				Window.alert( constants.errorsMapError() );
    			}
    
    			@Override
    			public void onSuccess( Map<String, Integer> errorsMap ) {
    				//messageArea.reset();
    				Integer invalidAssets = errorsMap.get( INVALID_ASSETS + assetListId );
    				if ( ( invalidAssets != null ) && ( invalidAssets > 0 ) ) {
    					
    					messageArea.setInfoMessage(constants.invalidAssetsContentClass() );
    				}
    			}
			} 
		);		

		busyIndicator = new BusyIndicator();
	}

	public void refresh() {
		mainContainer.clear();
		itemsButtonsContainer.clear();
		propertiesButtonsContainer.clear();
		showBusyIndicator();
		fetchMetadata( spec, record );
	}

	@Override
	public void commit() {
		this.previousName = record.getTitleList().getName();
		this.previousDescription = record.getTitleList().getDescription();
		this.previousType = record.getTitleList().getType();
		this.previousContentClass = record.getTitleList().getContentClass();
		this.previousListMetadataFields = record.getTitleList().getMetadataFields();

		record.getTitleList().setName( titleListForm.getName() );
		record.getTitleList().setDescription( titleListForm.getDescription() );
		record.getTitleList().setType( titleListForm.getType() );
		record.getTitleList().setContentClass( titleListForm.getContentClass() );
		record.getTitleList().setMetadataFields( titleListForm.getMetadataFields() );

		for ( UiAssetMap uiAssetMap : record.getTitleList().getAssets() ) {
			AssetMetadataForm form = uiAssetMapFormMap.get( uiAssetMap );
			if ( form != null ) {
				List<UiMetadataField> metadaFields = new ArrayList<UiMetadataField>();
				metadaFields.addAll( form.getMetadataFields() );
				uiAssetMap.setMetadataFields( metadaFields );
			}
		}
	}

	private void removeAssetsFromRecord( List<Long> titleAssetRecordIds ) {
		for(Long recordId : titleAssetRecordIds)
			record.getTitleList().getAssets().remove(new UiAssetMap(recordId));
	}

	@Override
	public UiTitleListRecord getRecord() {
		return record;
	}

	@Override
	public void revert() {
		this.record.getTitleList().setName( this.previousName );
		this.record.getTitleList().setDescription( this.previousDescription );
		this.record.getTitleList().setType( this.previousType );
		this.record.getTitleList().setContentClass( this.previousContentClass );
		this.record.getTitleList().setMetadataFields( this.previousListMetadataFields );
	}

	@Override
	public String getStyleName() {
		return null;
	}

	@Override
	public Widget getWidget() {
		return this;
	}

	@Override
	public void release() {
	}

	@Override
	public void saveFailed( Throwable throwable ) {
		if ( throwable instanceof UiValidationException ) {
			revert();
			messageArea.setErrorHTML(getErrorMessageFromList( ( (UiValidationException) throwable ).getErrorCodes() ));
			
			
		}
	}

	private String getErrorMessageFromList(List<String> errorCodes) {
		String message = "";
		if(errorCodes != null) {
			for(Iterator<String> i = errorCodes.iterator(); i.hasNext();) {
				String code = i.next();
				message += contentConstants.getString(code);
				if (i.hasNext()) {
					message += "<br>"; 
				}
			}
		}
		return message;
	}

	/**
	 * Builds the ui given the uititlelist
	 * 
	 * @param uiTitleList
	 */
	private void buildView( UiTitleList uiTitleList ) {
		// error panel
	//	mainContainer.add( messageArea );

		
		// add the table
		Widget assetTable = prepareTable( uiTitleList );
	//	tableButtonsContainer.add( assetTable ); --removed

		// add the buttons
		propertiesButtonsContainer.add( createButtonPanel( (FlexTableContainer) assetTable ) );
		
		
		
		itemsButtonsContainer.add( createItemsButtonPanel( (FlexTableContainer) assetTable ) );
		VerticalContainer propertyTableContainer = new VerticalContainer();
		propertyTableContainer.setStylePrimaryName( STYLE_PROPERTY_PANEL );
		propertyTableContainer.add( titleListForm );
		propertyTableContainer.setCellHorizontalAlignment( titleListForm, VerticalContainer.ALIGN_LEFT );
		int tabIndex = 0;
		if(parentPanel.getResizableContainer() != null) {
			tabIndex = parentPanel.getResizableContainer().getTabContainer().getTabBar().getSelectedTab();
		}
		parentPanel.removeResizableContainer();
		
		resizableContainer = new ResizableContainer(propertyTableContainer, "Properties", null);
		resizableContainer.addBottomWidget("Properties", propertiesButtonsContainer);
	
		resizableContainer.addTab(assetTable, "Items");
		resizableContainer.addBottomWidget("Items", itemsButtonsContainer);
		parentPanel.addResizableContainer(resizableContainer);
		if(tabIndex   == 1) {
			resizableContainer.selectTab("Items");
		}
		resizableContainer.getTabContainer().addSelectionHandler(new SelectionHandler<Integer>(){

			@Override
			public void onSelection(SelectionEvent<Integer> event) {
				messageArea.reset();
				
			}});
		titleListForm.initMetadataFields( uiTitleList.getMetadataFields() );
	}
	
	/**
	 * Builds the no permission view
	 * 
	 * @param uiTitleList
	 */
	private void buildNoPermissionView( UiTitleList uiTitleList ) {
		// error panel
//		mainContainer.add( messageArea);
		
		messageArea.setErrorMessage(constants.noViewPermission() );
		
		// cancel button is always shown.
		ButtonWidget cancelTitlesButton = new ButtonWidget( constants.cancelButtonName(), 
			new ClickHandler() {
    			@Override
    			public void onClick( ClickEvent event ) {
    				callback.cancel( TitleListDetailView.this );
    				History.newItem("Content.TitleLists.View");
    			}
    		} 
		);
		
		cancelTitlesButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		cancelTitlesButton.addStyleName(StyleNames.STYLE_EB_BTN);
		parentPanel.removeResizableContainer();
		
		resizableContainer = new ResizableContainer(new SimpleContainer(), "Items", null);
		
	
		
		resizableContainer.addBottomWidget("Items", cancelTitlesButton);
		
		
		parentPanel.addResizableContainer(resizableContainer);
	}

	private Widget createItemsButtonPanel( final FlexTableContainer assetTable ) {
		SimplePanel buttonPanel = new SimplePanel();
		HorizontalContainer buttonContainer = new HorizontalContainer();
		if ( security.isUserInRole( Permissions.TITLELIST_MODIFY ) ) {
			ButtonWidget saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {

				@Override
				public void onClick( ClickEvent event ) {
					if ( titleListForm.isValid() && allAssetMetadataFormsValid() ) {
						TitleListDetailView.this.callback.save( TitleListDetailView.this );
						
					} else {
						String invalidMessage = generateInvalidMessage();
						messageArea.setErrorHTML(invalidMessage );
						resizableContainer.updateSize();
					}
				}
			} );
			
			buttonContainer.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
			saveButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
	        saveButton.addStyleName(StyleNames.STYLE_EB_BTN);
	        saveButton.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
	        saveButton.addStyleName(StyleNames.STYLE_SAVE_BUTTON_ICON);

			
			buttonContainer.add( saveButton );
			}
		if ( security.isUserInRole( Permissions.TITLELIST_MODIFY ) ) {
			
			ButtonWidget addAssetsButton = new ButtonWidget( constants.addAssetsButtonName(),
					new ClickHandler() {

						@Override
						public void onClick( ClickEvent event ) {
							History.newItem( "Content.Search?titleListId=" + record.getKey().getId() );
							resizableContainer.selectTab("Items");
						}
					} );
			addAssetsButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
			addAssetsButton.addStyleName(StyleNames.STYLE_EB_BTN);
			addAssetsButton.addStyleName(StyleNames.STYLE_ADD_GREEN_BUTTON_ICON);

			ButtonWidget removeAssetsButton = new ButtonWidget( constants.removeAssetsButtonName(),
				new ClickHandler() {
					@Override
					public void onClick( ClickEvent event ) {
						List<Long> recordsToRemove = new ArrayList<Long>();
						//the following variable is used only for displaying success/failure message
						List<Long> titleIdsToRemove = new ArrayList<Long>();
						// Gather all asset ids that need to be removed
						int oldIndex = 0;
						for ( int i = DATA_ROW; i < assetTable.getRowCount(); i = i + 2 ) {
							// if this row is selected add the asset id to
							// the remove list
							if ( ( (CheckBoxWidget) assetTable.getWidget( i, CHECKBOX_COLUMN ) )
									.getValue() ) {
								UiTitleList uiTitleList = TitleListDetailView.this.record.getTitleList();
								UiAssetMap uiAssetMap = uiTitleList.getAssets().get( i - oldIndex - 1 );
								recordsToRemove.add(uiAssetMap.getId());
								titleIdsToRemove.add(uiAssetMap.getTitleId());
							}
							oldIndex = i - oldIndex;
						}
						if ( recordsToRemove.size() == 0 ) {
							messageArea.setErrorMessage( constants.assetSelectionRequired() );
							
							
							refresh();
							return;
						}
						removeAssets( record.getKey().getId(), recordsToRemove, titleIdsToRemove );
					}
				} 
			);
			removeAssetsButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
			removeAssetsButton.addStyleName(StyleNames.STYLE_EB_BTN);
			removeAssetsButton.addStyleName(StyleNames.STYLE_DELETE_BUTTON_ICON);

			
			buttonContainer.add( addAssetsButton );
			buttonContainer.add( removeAssetsButton );
		}

		// cancel button is always shown.
		ButtonWidget cancelTitlesButton = new ButtonWidget( constants.cancelButtonName(), 
			new ClickHandler() {
    			@Override
    			public void onClick( ClickEvent event ) {
    				callback.cancel( TitleListDetailView.this );
    				History.newItem("Content.TitleLists.View");
    			}
    		} 
		);
		cancelTitlesButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		cancelTitlesButton.addStyleName(StyleNames.STYLE_EB_BTN);
		buttonContainer.add( cancelTitlesButton );

		buttonPanel.add( buttonContainer );
		return buttonPanel;
	}
	/**
	 * Responsible to create all buttons seen on the titles page.
	 * 
	 * @param assetTable
	 * @return
	 */
	private Widget createButtonPanel( final FlexTableContainer assetTable ) {
		SimplePanel buttonPanel = new SimplePanel();
		HorizontalContainer buttonContainer = new HorizontalContainer();

		if ( security.isUserInRole( Permissions.TITLELIST_MODIFY ) ) {
			ButtonWidget saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {

				@Override
				public void onClick( ClickEvent event ) {
					if ( titleListForm.isValid() && allAssetMetadataFormsValid() ) {
						TitleListDetailView.this.callback.save( TitleListDetailView.this );
						
					} else {
						
						String invalidMessage = generateInvalidMessage();
						
						messageArea.setErrorHTML(invalidMessage );
						resizableContainer.updateSize();
					}
				}
			} );
			
			buttonContainer.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
			saveButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
	        saveButton.addStyleName(StyleNames.STYLE_EB_BTN);
	        saveButton.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
	        saveButton.addStyleName(StyleNames.STYLE_SAVE_BUTTON_ICON);
	        
			buttonContainer.add( saveButton );
			}

		// cancel button is always shown.
		ButtonWidget cancelTitlesButton = new ButtonWidget( constants.cancelButtonName(), 
			new ClickHandler() {
    			@Override
    			public void onClick( ClickEvent event ) {
    				callback.cancel( TitleListDetailView.this );
    				History.newItem("Content.TitleLists.View");
    			}
    		} 
		);
		cancelTitlesButton.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		cancelTitlesButton.addStyleName(StyleNames.STYLE_EB_BTN);
		buttonContainer.add( cancelTitlesButton );

		buttonPanel.add( buttonContainer );
		return buttonPanel;
	}
	
	private String generateInvalidMessage() {
		StringBuffer sbInvalidMessage = new StringBuffer( constants.invalidFormData() );
		for ( String invalidFieldMessage : titleListForm.getInvalidFieldsMessages() ) {
			sbInvalidMessage.append( "\n - " );
			sbInvalidMessage.append( invalidFieldMessage );
		}
		for ( AssetMetadataForm amf : assetMetadataFormList ) {
			List<String> invalidFieldMessageList = amf.getInvalidFieldsMessages();
			if ( invalidFieldMessageList.size() > 0 ) {
				sbInvalidMessage.append( "<br>  " );
				sbInvalidMessage.append( constants.invalidElementFormData() );
				sbInvalidMessage.append( " " );
				sbInvalidMessage.append( amf.getUiAssetMap().getTitleId() );
				sbInvalidMessage.append( "-" );
				sbInvalidMessage.append( amf.getUiAssetMap().getAsset().getType() );
			}
			for ( String invalidFieldMessage : invalidFieldMessageList ) {
				sbInvalidMessage.append( "<br>    - " );
				sbInvalidMessage.append( invalidFieldMessage );
			}
		}
	
		return sbInvalidMessage.toString();
		

		
	}
	
	private boolean allAssetMetadataFormsValid() {
		boolean allValid = true;
		
		for ( AssetMetadataForm amf : assetMetadataFormList ) {
			if ( !amf.isValid() ) {
				allValid = false;
				break;
			}
		}
		return allValid;
	}	

	private void removeAssets( long titleListId, final List<Long> titleAssetRecordIds, final List<Long> titleIds ) {
		service.removeAssetsFromTitleList( titleListId, titleAssetRecordIds, new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure( Throwable caught ) {
				StringBuilder sb = new StringBuilder();
				for ( Long titleId : titleIds ) {
					if ( sb.length() > 0 ) {
						sb.append( "," );
					}
					sb.append( titleId );
				}

				messageArea.setErrorMessage( constants.removeAssetsFailureMessage() + sb.toString() );
				
				
				refresh();
			}

			@Override
			public void onNeptuneSuccess( Void result ) {
				StringBuilder sb = new StringBuilder();
				for ( Long titleId : titleIds ) {
					if ( sb.length() > 0 ) {
						sb.append( "," );
					}
					sb.append( titleId );
				}
				removeAssetsFromRecord( titleAssetRecordIds );
				messageArea.setInfoMessage(constants.removeAssetsSuccessMessage() + " "
						+ sb.toString() );
				
				
				
				refresh();
			}
		} );
	}

	/**
	 * Populates the asset table with the every asset's metadata.
	 * 
	 * @param uiTitleList
	 * @return
	 */
	private Widget prepareTable( UiTitleList uiTitleList ) {
		// flex table
		final FlexTableContainer table = new FlexTableContainer();
		table.setStylePrimaryName( STYLE_TABLE );

		// drag controller
		TitleListTableRowDragController dragController = new TitleListTableRowDragController( RootPanel.get(), table );

		// drop controller
		TitleListRowMoveController rowDropController = new TitleListRowMoveController( table );
		rowDropController.addTableRowMoveHandler( new TableRowMoveHandler() {
			@Override
			public void onBeforeRowMove( TableRowBeforeMoveEvent event ) {
				/* Ignore the header row */
				if ( event.getTargetRowIndex() <= 0 )
					event.cancel();
			}

			@Override
			public void onRowMove( TableRowMoveEvent event ) {
				int oldIndex = event.getOldRowIndex();
				int newIndex = event.getRowIndex();
				if ( newIndex % 2 == 0 ) {
					// the row was dropped between the real row and the expansion row
					// the index should be incremented to the correct position,
					// below the expansion row
					newIndex++;
				}

				/*
				 * 'move' the asset in the model subtract 1 for header row,
				 * divide by 2 due to the expansion rows)
				 */
				record.getTitleList().move( ( oldIndex - 1 ) / 2, ( newIndex - 1 ) / 2 );

				/* Go through table, and re-style the rows */
				int start = ( oldIndex < newIndex ) ? oldIndex : newIndex;
				int end = ( oldIndex >= newIndex ) ? oldIndex : newIndex;
				for ( int index = start; index <= end; index++ ) {
					if ( index % 2 == 1 ) {
						String styleName = ( ( index / 2 ) % 2 == 0 ) ? TableConstants.STYLE_DATA_ODD_ROW
								: TableConstants.STYLE_DATA_EVEN_ROW;
						table.getRowFormatter().setStyleName( index, styleName );
					}
				}
			}
		} );
		dragController.registerDropController( rowDropController );

		/* table row and column indices */
		int rowIndex = 0;
		int columnIndex = 0;

		/* Create the header row */
		table.getRowFormatter().addStyleName( rowIndex, TableConstants.STYLE_HEADER_ROW );

		/* Add re-ordering label */
		LabelWidget reorderHeadingLabel = new LabelWidget( "" );
		reorderHeadingLabel.addStyleName( TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT );
		table.setWidget( 0, columnIndex++, reorderHeadingLabel );

		// show the check box only if the user has modify permissions
		if ( security.isUserInRole( Permissions.TITLELIST_MODIFY ) ) {
			final CheckBoxWidget headerChkBox = new CheckBoxWidget();
			headerChkBox.addClickHandler( new ClickHandler() {
				@Override
				public void onClick( ClickEvent event ) {
					// check/uncheck checkboxes in all the rows
					for ( int i = 1; i < table.getRowCount(); i=i+2 ) {
						( (CheckBoxWidget) table.getWidget( i, CHECKBOX_COLUMN ) ).setValue( headerChkBox
								.getValue() );
					}
				}
			} );
			table.setWidget( rowIndex, columnIndex++, headerChkBox );
		}
		List<UiMetadataField> elementMetadataFieldsFromType = titleListForm.getUiAssetListType()
				.getElementMetadata();
		if ( !elementMetadataFieldsFromType.isEmpty() ) {
			table.setWidget( rowIndex, columnIndex, new Label( "+" ) );
			table.getCellFormatter().addStyleName( rowIndex, columnIndex, STYLE_DATACELL );
			table.getCellFormatter().addStyleName( rowIndex, columnIndex, STYLE_DATACELL_CHECKBOX );
			columnIndex++;
		}

		for ( UiColumn col : record.getTitleList().getTitleColumns() ) {
			/* Add the column to the header row */
			LabelWidget label = new LabelWidget( col.getDisplayName() );
			label.addStyleName( TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT );
			table.setWidget( rowIndex, columnIndex++, label );
		}

		for ( UiColumn col : record.getTitleList().getAssetColumns() ) {
			/* Add the column to the header row */
			LabelWidget label = new LabelWidget( col.getDisplayName() );
			label.addStyleName( TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT );
			table.setWidget( rowIndex, columnIndex++, label );
		}

		CellFormatter cellFormatter = table.getCellFormatter();
		this.assetMetadataFormList = new ArrayList<AssetMetadataForm>();
		for ( UiAssetMap uam : uiTitleList.getAssets() ) {
			final UiAssetMap uiAssetMap = uam;
			rowIndex = table.getRowCount();
			columnIndex = 0;
			table.insertRow( rowIndex );

			// add handle at row, 0
			ImageWidget handle = new ImageWidget( DRAG_HANDLE_IMAGE_URL );
			table.setWidget( rowIndex, columnIndex, handle );
			cellFormatter.addStyleName( rowIndex, columnIndex, STYLE_DATACELL );
			cellFormatter.addStyleName( rowIndex, columnIndex, STYLE_DATACELL_ICON );
			dragController.makeDraggable( handle );
			columnIndex++;

			// check box for this row, if required
			if ( security.isUserInRole( Permissions.TITLELIST_MODIFY ) ) {
				CheckBoxWidget dataRowChkbox = new CheckBoxWidget();
				dataRowChkbox.addClickHandler( new ClickHandler() {
					@Override
					public void onClick( ClickEvent event ) {
						// If the check all was selected prior to un-selecting
						// this row, un-select the check all too.
						if ( ( (CheckBoxWidget) table.getWidget( 0, CHECKBOX_COLUMN ) ).getValue() ) {
							( (CheckBoxWidget) table.getWidget( 0, CHECKBOX_COLUMN ) ).setValue( false );
						}
					}
				} );
				table.setWidget( rowIndex, columnIndex, dataRowChkbox );
				cellFormatter.addStyleName( rowIndex, columnIndex, STYLE_DATACELL );
				cellFormatter.addStyleName( rowIndex, columnIndex, STYLE_DATACELL_CHECKBOX );
				columnIndex++;
			}

			SimplePanel expandedPanel = new SimplePanel();

			if ( !elementMetadataFieldsFromType.isEmpty() ) {
				AssetMetadataForm assetMetadataForm = new AssetMetadataForm( uiTitleList.getKey().getId(),
						uiAssetMap, elementMetadataFieldsFromType );
				assetMetadataForm.initMetadataFields( uiAssetMap.getMetadataFields() );
				assetMetadataFormList.add( assetMetadataForm );
				uiAssetMapFormMap.put( uiAssetMap, assetMetadataForm );
				expandedPanel.add( assetMetadataForm );
				expandedPanel.setVisible( false );
				final ExpandCollapseButton expandCollapseButton = new ExpandCollapseButton( expandedPanel );
				expandCollapseButton.addClickHandler( new ClickHandler() {
					public void onClick( ClickEvent event ) {
						int clickedRowIndex = table.getCellForEvent(event).getRowIndex();
						handleExpandCollapseClick( table, clickedRowIndex + 1, expandCollapseButton );
					}
				} );
				table.setWidget( rowIndex, columnIndex, expandCollapseButton );

				table.getCellFormatter().addStyleName( rowIndex, columnIndex, STYLE_DATACELL );
				table.getCellFormatter().addStyleName( rowIndex, columnIndex, STYLE_DATACELL_CHECKBOX );
				columnIndex++;
			}

			String styleName = ( ( rowIndex / 2 ) % 2 == 0 ) ? TableConstants.STYLE_DATA_ODD_ROW 
					: TableConstants.STYLE_DATA_EVEN_ROW;
			table.getRowFormatter().setStyleName( rowIndex, styleName );

			for ( UiColumn col : record.getTitleList().getTitleColumns() ) {
				String fieldInternalColumnName = TableColumnNameHelper.getColumnName( col.getName(), col
						.getSectionName() );
				UiField field = getFieldForTitleColumn( uam.getTitle(), col );
				String fieldValue = ( field != null ) ? field.getValue() : "";
				LabelWidget label = new LabelWidget( fieldValue );

				// if this is the id column, create a hyperlink to the title detail.
				if ( fieldInternalColumnName.equalsIgnoreCase( ID_COLUMN_NAME )
						&& security.isUserInRole( com.tandbergtv.cms.portal.content.client.Permissions.TITLE_VIEW ) ) {
					label.setStyleName( TableConstants.STYLE_DATA_LINK );
					label.addClickHandler( new ClickHandler() {
						@Override
						public void onClick( ClickEvent event ) {
							History.newItem( "Content.Search.Id=" + uiAssetMap.getTitle().getTitleId() );
						}
					} );
				} else {
					label.addStyleName( TableConstants.STYLE_DATA_TEXT );
				}

				table.setWidget( rowIndex, columnIndex, label );
				cellFormatter.addStyleName( rowIndex, columnIndex, TableConstants.STYLE_DATACELL );
				String cellStyle = getCellStyle( col );
				if ( cellStyle != null ) {
					cellFormatter.addStyleName( rowIndex, columnIndex, cellStyle );
				}
				columnIndex++;
			}

			for ( UiColumn col : record.getTitleList().getAssetColumns() ) {
				UiField field = getFieldForAssetColumn( uam.getAsset(), col );
				String fieldValue = ( field != null ) ? field.getValue() : "";
				LabelWidget label = new LabelWidget( fieldValue );
				label.addStyleName( TableConstants.STYLE_DATA_TEXT );

				table.setWidget( rowIndex, columnIndex, label );
				cellFormatter.addStyleName( rowIndex, columnIndex, TableConstants.STYLE_DATACELL );
				String cellStyle = getCellStyle( col );
				if ( cellStyle != null ) {
					cellFormatter.addStyleName( rowIndex, columnIndex, cellStyle );
				}
				columnIndex++;
			}
			rowIndex++;
			table.getRowFormatter().addStyleName( rowIndex, "display-none" );
			// Needed to create a widget at column '0' to support drag and drop
			table.setWidget( rowIndex, 0, new SimplePanel() ); 
			table.setWidget( rowIndex, 1, expandedPanel );
			( (FlexCellFormatter) table.getCellFormatter() ).setColSpan( rowIndex, 1, columnIndex - 1 );

		}

		return table;
	}

	private void handleExpandCollapseClick( FlexTableContainer table, int rowIndex, ExpandCollapseButton expandCollapseButton ) {
		expandCollapseButton.changeState();
		if ( expandCollapseButton.isExpanded() ) {
			table.getRowFormatter().removeStyleName( rowIndex, "display-none" );
		} else {
			table.getRowFormatter().addStyleName( rowIndex, "display-none" );
		}
	}

	/*
	 * Get the field to render for the given column
	 */
	private UiField getFieldForTitleColumn( UiTitle title, UiColumn column ) {
		UiField field = null;
		String columnName = TableColumnNameHelper.getColumnName( column.getName(), column.getSectionName() );

		for ( UiField f : title.getFields() ) {
			String fieldName = TableColumnNameHelper.getColumnName( f.getName(), f.getParentAssetType() );
			if ( columnName != null && columnName.equals( fieldName ) ) {
				field = f;
				break;
			}
		}

		return field;
	}

	/*
	 * Get the field to render for the given column
	 */
	private UiField getFieldForAssetColumn( UiAsset asset, UiColumn column ) {
		UiField field = null;
		String columnName = TableColumnNameHelper.getColumnName( column.getName(), null );

		if ( columnName.equals( "type" ) ) {
			field = new UiField( "type", column.getDisplayName(), asset.getType() );
		} else {
			for ( UiField f : asset.getFields() ) {
				String fieldName = TableColumnNameHelper.getColumnName( f.getName(), f.getParentAssetType() );
				if ( columnName != null && columnName.equals( fieldName ) ) {
					field = f;
					break;
				}
			}
		}

		return field;
	}

	/*
	 * Get the style to apply to the table cell based on the column
	 */
	private String getCellStyle( UiColumn column ) {
		String cellStyle = TableConstants.STYLE_DATACELL_GENERAL;
		if ( column.getDataType() != null ) {
			switch ( column.getDataType() ) {
			case BOOLEAN:
			case STRING:
				cellStyle = TableConstants.STYLE_DATACELL_TEXT;
				break;
			case DATE:
			case TIME:
				cellStyle = TableConstants.STYLE_DATACELL_DATE;
				break;
			case FLOAT:
			case INTEGER:
				cellStyle = TableConstants.STYLE_DATACELL_NUMERIC;
				break;
			}
		}
		return cellStyle;
	}

	/**
	 * Shows the busy indicator in the center of the screen
	 */
	private void showBusyIndicator() {
		busyIndicator.center();
	}

	/**
	 * Hides the busy indicator
	 */
	private void hideBusyIndicator() {
		busyIndicator.hide();
	}
	
	@Override
	protected void onUnload() {
		hideBusyIndicator();
		super.onUnload();
	}
}
