package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewService;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.imageeditor.TypedImageBoxWidget;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetListType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiDataType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListTypeService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListTypeServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DateWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.WidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

public class TitleListForm extends Composite {

	private static final String TIME_FORMAT = "HH:mm:ss";
	private static final String DATE_FORMAT = "yyyy-MM-dd";
	private static final String OFFER = "Offer";
	
	// services
	private TitleListConstants constants = (TitleListConstants) GWT.create( TitleListConstants.class );
	private ITitleListTypeServiceAsync titleListTypeService = (ITitleListTypeServiceAsync) GWT
			.create( ITitleListTypeService.class );
	private IContentClassViewServiceAsync contentClassService = (IContentClassViewServiceAsync) GWT
			.create( IContentClassViewService.class );

	private VerticalContainer verticalContainer;

	private FormContainer form;

	// name widget
	private TypedTextBoxWidget<String> nameWidget;

	// description widget
	private TextAreaWidget descriptionWidget;
	private int DESCRIPTION_VISIBLE_COUNT = 5;
	// Note: This is a magic number or else we see a shadow on the right edge of
	// the title table.
	private int DESCRIPTION_CHAR_WIDTH = 40;

	// type widget
	private ListBoxWidget<String> typeWidget;

	// content class widget
	private ListBoxWidget<Long> contentClassWidget;

	// button widgets
	private List<ButtonWidget> buttonsList;

	// the ui title list
	private UiTitleList uiTitleList;

	// the list metadata fields
	private Map<UiMetadataField, DataTypeWidget<?>> metadataFieldsMap;

	// the callback to be invoked when the form finishes rendering the
	// components
	private NeptuneAsyncCallback<TitleListForm> callback;
	
	private UiAssetListType uiAssetListType;
	
	private BusyIndicator busyIndicator;

	public TitleListForm() {
		this( null, null );
	}

	public TitleListForm( UiTitleList uiTitleList, NeptuneAsyncCallback<TitleListForm> callback ) {
		this.uiTitleList = uiTitleList;
		this.callback = callback;
		this.metadataFieldsMap = new HashMap<UiMetadataField, DataTypeWidget<?>>();
		this.busyIndicator = new BusyIndicator();
		init();
	}

	/**
	 * Inits input and widgets used by this form.
	 */
	private void init() {
		this.verticalContainer = new VerticalContainer();
		this.buttonsList = new ArrayList<ButtonWidget>();

		IValueConverter<String> converter = new IValueConverter<String>() {

			@Override
			public String getStringValue( String typedValue ) {
				return typedValue;
			}

			@Override
			public String getTypedValue( String value ) throws ValueFormatException {
				value = value.trim();
				if ( value.equals( "" ) ) {
					throw new ValueFormatException( constants.requiredFieldToolTip() );
				}
				return value;
			}
		};
		nameWidget = new TypedTextBoxWidget<String>( converter );
		nameWidget.setErrorToolTip( constants.requiredFieldToolTip() );

		descriptionWidget = new TextAreaWidget();
		descriptionWidget.setCharacterWidth( DESCRIPTION_CHAR_WIDTH );
		descriptionWidget.setVisibleLines( DESCRIPTION_VISIBLE_COUNT );
		if ( uiTitleList != null ) {
			nameWidget.setValue( uiTitleList.getName() );
			descriptionWidget.setValue( uiTitleList.getDescription() );
		}

		typeWidget = getTitleListTypeListBox();
		contentClassWidget = getTitleListContentClassListBox();

		initBaseForm();
		verticalContainer.add( getForm() );
		verticalContainer.setWidth( "100%" );

		this.initWidget( verticalContainer );
	}

	private void initBaseForm() {
		form = new FormContainer( HasHorizontalAlignment.ALIGN_LEFT );
		form.addRow( constants.titleListNameLabel(), nameWidget, true );
		form.addRow( constants.titleListTypeLabel(), typeWidget, true );
		form.addRow( constants.titleListDescriptionLabel(), descriptionWidget );
		form.addRow( constants.titleListContentClassLabel(), contentClassWidget );
		for ( ButtonWidget button : this.buttonsList ) {
			form.addButton( button );
		}
	}

	private ListBoxWidget<String> getTitleListTypeListBox() {
		final ListBoxWidget<String> lbTitleListTypes = new ListBoxWidget<String>();
		lbTitleListTypes.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange( ChangeEvent event ) {
				handleTypeChange();
			}
		} );
		titleListTypeService.getTypesWithoutMetadata( new NeptuneAsyncCallback<List<UiAssetListType>>() {

			@Override
			public void onNeptuneFailure( Throwable caught ) {
				Window.alert( constants.failureGettingTypes() );
			}

			@Override
			public void onNeptuneSuccess( List<UiAssetListType> result ) {
				for ( UiAssetListType uiAssetListType : result ) {
					lbTitleListTypes.addItem( uiAssetListType.getDisplayName(), uiAssetListType.getName() );
				}
				if ( uiTitleList != null ) {
					typeWidget.setSelectedItem( uiTitleList.getType() );
					typeWidget.setEnabled( false );
				}
				handleTypeChange();
			}
		} );

		return lbTitleListTypes;
	}

	private ListBoxWidget<Long> getTitleListContentClassListBox() {
		final ListBoxWidget<Long> lbTitleListContentClass = new ListBoxWidget<Long>();
		contentClassService.getContentClassListWithoutMetadata( 
			new NeptuneAsyncCallback<List<UIContentClass>>() {

				@Override
				public void onNeptuneFailure( Throwable caught ) {
					Window.alert( constants.failureGettingContentClasses() );
				}

				@Override
				public void onNeptuneSuccess( List<UIContentClass> result ) {
					lbTitleListContentClass.addItem( "", null );
					for ( UIContentClass uiContentClass : result ) {
						if((uiContentClass.getTypeId() != 1)
							&& 
							(!uiContentClass.getName().equalsIgnoreCase(OFFER))) {
							lbTitleListContentClass.addItem( uiContentClass.getName(), uiContentClass.getId() );
						}
					}
					if ( uiTitleList != null ) {
						contentClassWidget.setSelectedItem( uiTitleList.getContentClass() );
						contentClassWidget.setEnabled( false );
					}
				}
			} 
		);

		return lbTitleListContentClass;
	}

	private void handleTypeChange() {
		showBusyIndicator();
		titleListTypeService.getTypeByName( typeWidget.getSelectedItem(),
			new NeptuneAsyncCallback<UiAssetListType>() {

				@Override
				public void onNeptuneFailure( Throwable caught ) {					
					Window.alert( constants.failureGettingType() );
					hideBusyIndicator();
				}

				@Override
				public void onNeptuneSuccess( UiAssetListType result ) {
					TitleListForm.this.uiAssetListType = result;
					verticalContainer.clear();
					metadataFieldsMap.clear();
					initBaseForm();
					verticalContainer.add( form );

					DefaultDataTypeWidgetFactory factory = new DefaultDataTypeWidgetFactory();
					factory.setInputDateFormat( DATE_FORMAT );
					factory.setInputTimeFormat( TIME_FORMAT );

					for ( UiMetadataField metadataField : result.getListMetadata() ) {
						DataTypeWidget<?> dataTypeWidget = createDataTypeWidget( factory,
								metadataField );

						if ( dataTypeWidget != null ) {
							metadataFieldsMap.put( metadataField, dataTypeWidget );
							form.addRow( metadataField.getDisplayName(), dataTypeWidget, metadataField.isRequired() );
						}
					}
					if ( callback != null ) {
						callback.onSuccess( TitleListForm.this );
					}
					hideBusyIndicator();
				}
			} 
		);
	}

	private DataTypeWidget<?> createDataTypeWidget( DefaultDataTypeWidgetFactory factory,
			UiMetadataField metadataField ) {

		DataTypeWidget<?> dataTypeWidget = null;

		if ( UiDataType.BOOLEAN.equals( metadataField.getDataType() ) ) {
			dataTypeWidget = factory.createBooleanWidget( new WidgetConfiguration() );

		} else if ( UiDataType.DATE.equals( metadataField.getDataType() ) ) {
			DateWidgetConfiguration dateConfig = new DateWidgetConfiguration();
			dateConfig.setDateFormat( DATE_FORMAT );
			dataTypeWidget = factory.createDateWidget( dateConfig );

		} else if ( UiDataType.FLOAT.equals( metadataField.getDataType() ) ) {
			dataTypeWidget = factory.createFloatWidget( new WidgetConfiguration() );

		} else if ( UiDataType.INTEGER.equals( metadataField.getDataType() ) ) {
			dataTypeWidget = factory.createIntegerWidget( new WidgetConfiguration() );

		} else if ( UiDataType.STRING.equals( metadataField.getDataType() ) ) {
			StringWidgetConfiguration swc = new StringWidgetConfiguration();
			List<UiMetadataField.Option> optionsList = metadataField.getOptions();
			if( optionsList != null && !optionsList.isEmpty() ) {
				List<UIValueOption> options = new ArrayList<UIValueOption>();
				for( UiMetadataField.Option option : optionsList ) {
					UIValueOption uiso = new UIValueOption( option.getName(), option.getValue() );
					options.add( uiso );
				}
				swc.setAnyValueAllowed( false );
				swc.setOptions( options );
			}
			dataTypeWidget = factory.createStringWidget( swc );

		} else if ( UiDataType.TIME.equals( metadataField.getDataType() ) ) {
			TimeWidgetConfiguration timeConfig = new TimeWidgetConfiguration();
			timeConfig.setTimeFormat( TIME_FORMAT );
			dataTypeWidget = factory.createTimeWidget( timeConfig );
			
		} else if ( UiDataType.IMAGE.equals( metadataField.getDataType() ) ) {
			dataTypeWidget = createImageWidget( metadataField.getName() );
		} 

		return dataTypeWidget;
	}

	public FormContainer getForm() {
		return form;
	}

	public void addButton( ButtonWidget button ) {
		this.buttonsList.add( button );
	}

	public void removeButton( ButtonWidget button ) {
		this.buttonsList.remove( button );
	}

	public UiTitleList getCurrentUiTitleList() {
		UiTitleList uiTitleList = new UiTitleList();
		uiTitleList.setName( nameWidget.getValue() );
		uiTitleList.setType( typeWidget.getSelectedItem() );
		uiTitleList.setDescription( descriptionWidget.getValue() );
		uiTitleList.setContentClass( contentClassWidget.getSelectedItem() );
		uiTitleList.setMetadataFields( new ArrayList<UiMetadataField>( metadataFieldsMap.keySet() ) );

		updateMetadataFields();

		return uiTitleList;
	}

	private void updateMetadataFields() {
		Set<Entry<UiMetadataField, DataTypeWidget<?>>> listMetadataEntries = metadataFieldsMap.entrySet();
		for ( Entry<UiMetadataField, DataTypeWidget<?>> entry : listMetadataEntries ) {
			entry.getKey().setValue( entry.getValue().getTextValue() );
		}
	}

	public void setBorderWidth( int width ) {
		verticalContainer.setBorderWidth( width );
	}

	public String getName() {
		return nameWidget.getValue();
	}

	public String getDescription() {
		return descriptionWidget.getValue();
	}

	public String getType() {
		return typeWidget.getSelectedItem();
	}

	public Long getContentClass() {
		return contentClassWidget.getSelectedItem();
	}

	public List<UiMetadataField> getMetadataFields() {
		updateMetadataFields();
		return new ArrayList<UiMetadataField>( metadataFieldsMap.keySet() );
	}

	public void initMetadataFields( List<UiMetadataField> metadataFields ) {
		for ( UiMetadataField uiMetadataField : metadataFields ) {
			for ( Entry<UiMetadataField, DataTypeWidget<?>> entry : metadataFieldsMap.entrySet() ) {
				if ( uiMetadataField.getName().equals( entry.getKey().getName() ) ) {
					String value = uiMetadataField.getValue();
					entry.getValue().setTextValue( value );
					break;
				}
			}
		}
	}
	
	private TypedImageBoxWidget<String> createImageWidget(String metadataFieldName) {
		IValueConverter<String> converter = new StringConverter();
		
		SaveImageRequest saveImageRequest = new SaveImageRequest();
		if ( uiTitleList != null ) {			
			saveImageRequest.setAssetListId( uiTitleList.getKey().getId() );
			saveImageRequest.setMetadataFieldName( metadataFieldName );
		}

		TypedImageBoxWidget<String> widget = new TypedImageBoxWidget<String>( converter, saveImageRequest );
		
		return widget;
	}

	public UiAssetListType getUiAssetListType() {
		return uiAssetListType;
	}

	public boolean isValid() {
		return getInvalidFieldsMessages().size() == 0;
	}
	
	public List<String> getInvalidFieldsMessages() {
		List<String> invalidFields = new ArrayList<String>();
		
		if ( !nameWidget.isValidValue() ) {
			invalidFields.add( constants.titleListNameLabel() + " (" + nameWidget.getErrorToolTip() + ")" );
		} 
		
		Set<Entry<UiMetadataField, DataTypeWidget<?>>> entries = metadataFieldsMap.entrySet();
		for ( Entry<UiMetadataField, DataTypeWidget<?>> entry : entries ) {
			UiMetadataField field = entry.getKey();
			DataTypeWidget<?> widget = entry.getValue();
			
			if ( field.isRequired() ) {
				if ( ( widget.getTextValue() == null ) 
						|| ( widget.getTextValue().trim().equals( "" ) ) ) {
					invalidFields.add( field.getDisplayName() + " (" + constants.requiredFieldToolTip() + ")" );
					widget.showValidationError( constants.requiredFieldToolTip() );
				}
			} 
			if ( !widget.isValidValue() ) {
				invalidFields.add( field.getDisplayName() + " (" + widget.getErrorToolTip() + ")" );
			}
		}
		
		return invalidFields;
	}
	
	/**
	 * Shows the busy indicator in the center of the screen
	 */
	private void showBusyIndicator() {
		busyIndicator.center();
	}

	/**
	 * Hides the busy indicator
	 */
	private void hideBusyIndicator() {
		busyIndicator.hide();
	}
	
	/**
	 * When unloading the widget, ensure that the feedback popup is hidden
	 * 
	 * @see com.google.gwt.user.client.ui.Widget#onUnload()
	 */
	@Override
	protected void onUnload() {
		/* Hide the busy indicator */
		if (busyIndicator != null) {
			busyIndicator.hide();
		}

		super.onUnload();
	}

}
