package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.util.Area;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.WidgetArea;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Widget;

public class TitleListRowMoveController extends TableRowDropController {

	public TitleListRowMoveController( FlexTable table ) {
		super( table );
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveController#moveRow(int, int)
	 */
	@Override
	protected void moveRow( int index, int targetIndex ) {
		if ( targetIndex%2 == 0 ) {
			// the row was dropped between the real row and the expansion row
			// the index should be incremented to the correct position,
			// below the expansion row
			targetIndex++;
		}
		if ( index > targetIndex ) {
			// move real row and expansion row up			
			moveRowContent( index, targetIndex );
			moveRowContent( index+1, targetIndex+1 );
		} else {
			// move real row and expansion row down
			moveRowContent( index, targetIndex+1 );
			moveRowContent( index, targetIndex+1 );
		}
	}
	
	/*
	 * Override the base class method to account for header and expansion row widgets
	 */
	@Override
	protected int getTargetRowIndex(DragContext context) {
		CoordinateLocation location = new CoordinateLocation(context.mouseX, context.mouseY);
		int targetIndex = findIntersect(getTable(), location);
		return targetIndex;
	}
	
	protected int findIntersect(IndexedPanel parent, Location location) {
	  	int widgetCount = parent.getWidgetCount();

	    // short circuit in case dropTarget has no children
	    if (widgetCount == 0) {
	      return 0;
	    }


	    // binary search over range of widgets to find intersection
	    int low = 0;
	    int high = (widgetCount-1)/2;  //widgetCount include the header and expansion row widgets

	    while (true) {
	      int mid = (low + high) / 2;
	      assert mid >= low;
	      assert mid < high;
	      Widget widget = parent.getWidget(widgetIndex(mid));
	      WidgetArea midArea = new WidgetArea(widget, null);
	      if (mid == low) {
	        if (mid == 0) {
	          if (locationIndicatesIndexFollowingWidget(midArea, location)) {
	            return widgetIndex(high);
	          } else {
	            return widgetIndex(mid);
	          }
	        } else {
	          return widgetIndex(high);
	        }
	      }
	      if (midArea.getBottom() < location.getTop()) {
	        low = mid;
	      } else if (midArea.getTop() > location.getTop()) {
	        high = mid;
	      } else if (midArea.getRight() < location.getLeft()) {
	        low = mid;
	      } else if (midArea.getLeft() > location.getLeft()) {
	        high = mid;
	      } else {
	        if (locationIndicatesIndexFollowingWidget(midArea, location)) {
	          return widgetIndex(mid + 1);
	        } else {
	          return widgetIndex(mid);
	        }
	      }
	    }
	}

    int widgetIndex(int index) {
    	return (1+(2*index));
    }
  
    //Assuming we are using LocationWidgetComparator = BOTTOM_HALF_COMPARATOR;
    boolean locationIndicatesIndexFollowingWidget(Area widgetArea, Location location) {
        return location.getTop() > widgetArea.getTop() + widgetArea.getHeight() / 2;
    }
	
	
}
